/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.remoting.jersey;

import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.CallbackHandler;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.jersey.JerseyChannel;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;

public class JerseyClient
implements Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(JerseyClient.class);
    private static volatile JerseyClient instance;
    private final AtomicReference<javax.ws.rs.client.Client> client = new AtomicReference<Object>(null);
    private Map<String, Channel> channels = new HashMap<String, Channel>();

    public JerseyClient() {
        this.setClient(this.getClient(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JerseyClient getInstance() {
        if (instance != null) return instance;
        Class<JerseyClient> clazz = JerseyClient.class;
        synchronized (JerseyClient.class) {
            if (instance != null) return instance;
            instance = new JerseyClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Channel connect(URL url) {
        try {
            JerseyChannel channel = new JerseyChannel();
            channel.setWebTarget(this.getTarget(url));
            channel.setClient(this.getClient());
            this.channels.put(url.getAddressString(), channel);
            return channel;
        }
        catch (Exception e) {
            LOGGER.error("Create jersey connect:" + url + " error!", (Throwable)e);
            throw new RuntimeException("Create jersey connect:" + url + " error!", e);
        }
    }

    private WebTarget getTarget(URL targetUrl) {
        return this.getClient().target(this.getBaseUri(targetUrl));
    }

    private javax.ws.rs.client.Client getClient(ClientConfig clientConfig) {
        if (clientConfig == null) {
            clientConfig = new ClientConfig();
        }
        clientConfig.connectorProvider((ConnectorProvider)new HttpUrlConnectorProvider());
        clientConfig.register(JacksonFeature.class);
        return ClientBuilder.newClient((Configuration)clientConfig);
    }

    public javax.ws.rs.client.Client getClient() {
        return this.client.get();
    }

    public void setClient(javax.ws.rs.client.Client clientIn) {
        this.client.getAndSet(clientIn);
    }

    public URI getBaseUri(URL targetUrl) {
        URI uri;
        try {
            uri = UriBuilder.fromUri((String)("http://" + targetUrl.getIpAddress() + "/")).port(targetUrl.getPort()).build(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("get server URI error!", (Throwable)e);
            throw new RuntimeException("get server URI error!", e);
        }
        return uri;
    }

    public Collection<Channel> getChannels() {
        return null;
    }

    public Channel getChannel(InetSocketAddress remoteAddress) {
        Channel c = this.channels.get(NetUtil.toAddressString((InetSocketAddress)remoteAddress));
        if (c == null) {
            return null;
        }
        if (!c.isConnected()) {
            this.connect(new URL(remoteAddress));
        }
        return c;
    }

    public Channel getChannel(URL url) {
        Channel c = this.channels.get(url.getAddressString());
        if (c == null) {
            return null;
        }
        if (!c.isConnected()) {
            this.connect(url);
        }
        return c;
    }

    public List<ChannelHandler> getChannelHandlers() {
        return null;
    }

    public InetSocketAddress getLocalAddress() {
        return NetUtil.getLocalSocketAddress();
    }

    public void close() {
    }

    public void close(Channel channel) {
    }

    public boolean isClosed() {
        return false;
    }

    public void sendOneway(Channel channel, Object message) {
    }

    public Object sendSync(Channel channel, Object message, int timeoutMillis) {
        return null;
    }

    public void sendCallback(Channel channel, Object message, CallbackHandler callbackHandler, int timeoutMillis) {
    }
}

