/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.conf;

import com.alipay.drm.client.api.annotation.BeforeUpdate;
import com.antcloud.antvip.common.log.ConfigLogger;
import com.antcloud.antvip.common.model.VipServer;
import com.antcloud.antvip.common.utils.HostUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public class AntVipConfigure {
    public static final ConfigLogger LOGGER = ConfigLogger.getInstance();
    private static final char SERVER_PORT_SPLIT = ':';
    private static final String env = HostUtil.getEnv();
    private static AntVipConfigure ins;
    private String loggerRootPath;
    private String serverLoggerRootPath;
    private final VipServer localServer;
    private int serverPort = 12200;
    private int serverWeight = 5;
    private String webHost;
    private Boolean needSecurity;
    private String securityUrl;
    private String securityWhiteList;
    private int serverListThreshold = 4;
    private int waitServerListSec = 10;
    private long intervalMsWhenRaising = 500L;
    private long intervalMsWhenFalling = 500L;
    private String zone;
    private int healthCheckSchedulerExecutorFixedPoolSize = Runtime.getRuntime().availableProcessors();
    private int healthCheckBossCount = Runtime.getRuntime().availableProcessors() + 2;
    private int healthCheckWorkerCount = Runtime.getRuntime().availableProcessors() + 2;
    private int healthCheckTimeoutExecutorFixedPoolSize = Runtime.getRuntime().availableProcessors();
    private int healthCheckTimeoutExecutorQueueSize = 0x100000;
    private boolean useDiskCache = true;
    private String diskStoreDir;
    private long pollingWorkerIntervalMs = 600L;
    private int printIfVipDomainChangedSizeLessThan = 5;
    private long ioErrorIntervalSeconds = 1L;
    private long successParkIntervalMs = 500L;
    private long unknownErrorIntervalSeconds = 5L;
    private long monitorTickDurationSec = 1L;
    private long healthCheckMonitorIntervalSec = 60L;
    private long checksumWorkerMonitorIntervalSec = 60L;
    private long trServerMonitorIntervalSec = 60L;
    private long syncServerMonitorIntervalSec = 60L;
    private long syncWebMonitorIntervalSec = 60L;
    private int pollWorkerExecutorCorePoolSize = Runtime.getRuntime().availableProcessors() * 2;
    private int pollWorkerExecutorMaxPoolSize = Runtime.getRuntime().availableProcessors() * 5;
    private int pollWorkerExecutorQueueSize = 102400;
    private int trServerExecutorCorePoolSize = Runtime.getRuntime().availableProcessors() * 2;
    private int trServerExecutorMaxPoolSize = Runtime.getRuntime().availableProcessors() * 5;
    private int trServerExecutorQueueSize = 102400;
    private int checkServicePort = 9500;
    private long requestTimeLimitMS = 50000L;
    private long islandCheckIntervalMs = 1500L;
    private boolean frequentPollingControl = true;
    private static final String DEFAULT_ZONE = "ENV";

    public static AntVipConfigure getInstance() {
        return ins;
    }

    private AntVipConfigure() throws FileNotFoundException, IOException, NumberFormatException, IllegalArgumentException, IllegalAccessException {
        this(env + "/" + "antvip.properties");
    }

    private AntVipConfigure(String configFileName) throws FileNotFoundException, IOException, NumberFormatException, IllegalArgumentException, IllegalAccessException {
        this.diskStoreDir = this._getDefaultDiskStoreDir();
        InputStream in = AntVipConfigure.class.getClassLoader().getResourceAsStream(configFileName);
        Properties props = new Properties();
        Class<?> clazz = this.getClass();
        if (in != null) {
            props.load(in);
            in.close();
            props.putAll((Map<?, ?>)System.getProperties());
            for (Field field : clazz.getDeclaredFields()) {
                String value;
                if (Modifier.isStatic(field.getModifiers()) || (value = props.getProperty("com.antcloud.antvip." + field.getName())) == null) continue;
                field.setAccessible(true);
                if (field.getType().equals(Integer.TYPE)) {
                    field.set(this, Integer.parseInt(value));
                    continue;
                }
                if (field.getType().equals(Long.TYPE)) {
                    field.set(this, Long.parseLong(value));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    field.set(this, value);
                    continue;
                }
                field.set(this, Boolean.parseBoolean(value));
            }
        }
        this.setConfigureValueFromEnv();
        String _zone = System.getProperty("com.alipay.ldc.zone");
        if (_zone != null && !_zone.isEmpty()) {
            this.zone = _zone;
        }
        if (this.zone == null || "".equals(this.zone)) {
            this.zone = DEFAULT_ZONE;
        }
        this.localServer = new VipServer(HostUtil.getIp() + ':' + this.serverPort, HostUtil.getHostname(), this.serverWeight, true);
    }

    private void setConfigureValueFromEnv() {
        String env = System.getenv("YUNYOU_ENV");
        if (StringUtils.hasText((String)env)) {
            String securityWhiteList;
            String securityUrl;
            String needSecurity = System.getenv("needSecurity");
            if (StringUtils.hasText((String)needSecurity)) {
                this.setNeedSecurity(Boolean.valueOf(needSecurity));
            }
            if (StringUtils.hasText((String)(securityUrl = System.getenv("securityUrl")))) {
                this.setSecurityUrl(securityUrl);
            }
            if (StringUtils.hasText((String)(securityWhiteList = System.getenv("securityWhiteList")))) {
                this.setSecurityWhiteList(securityWhiteList);
            }
        }
    }

    private String _getDefaultDiskStoreDir() {
        String userHome = System.getProperty("user.home");
        if (userHome == null || userHome.isEmpty()) {
            userHome = "/home/admin";
        }
        if (!userHome.endsWith(File.separator)) {
            userHome = userHome + File.separator;
        }
        return userHome + "conf/" + "acvip-server-cache" + File.separator;
    }

    @BeforeUpdate
    public void before(String key, Object value) {
        LOGGER.info(AntVipConfigure.class, ">>>>>>>>>>> drm:" + key + ":" + value);
    }

    public void print(Logger logger) {
        if (logger.isInfoEnabled()) {
            logger.info("env=" + env);
            Field[] fields = AntVipConfigure.class.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                f.setAccessible(true);
                if (Modifier.isStatic(f.getModifiers())) continue;
                try {
                    logger.info(f.getName() + "=" + f.get(this));
                    continue;
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getWebHost() {
        return this.webHost;
    }

    public int getServerWeight() {
        return this.serverWeight;
    }

    public int getServerListThreshold() {
        return this.serverListThreshold;
    }

    public int getWaitServerListSec() {
        return this.waitServerListSec;
    }

    public VipServer getLocalServer() {
        return this.localServer;
    }

    public long getIntervalMsWhenRaising() {
        return this.intervalMsWhenRaising;
    }

    public long getIntervalMsWhenFalling() {
        return this.intervalMsWhenFalling;
    }

    public String getZone() {
        return this.zone;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
        this.localServer.setHost(HostUtil.getIp() + ':' + this.serverPort);
    }

    public void setWebHost(String webHost) {
        this.webHost = webHost;
    }

    public void setServerWeight(int serverWeight) {
        this.serverWeight = serverWeight;
        this.localServer.setWeight(serverWeight);
    }

    public void setServerListThreshold(int serverListThreshold) {
        this.serverListThreshold = serverListThreshold;
    }

    public void setWaitServerListSec(int waitServerListSec) {
        this.waitServerListSec = waitServerListSec;
    }

    public void setIntervalMsWhenRaising(long intervalMsWhenRaising) {
        this.intervalMsWhenRaising = intervalMsWhenRaising;
    }

    public void setIntervalMsWhenFalling(long intervalMsWhenFalling) {
        this.intervalMsWhenFalling = intervalMsWhenFalling;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getLoggerRootPath() {
        return this.loggerRootPath;
    }

    public void setLoggerRootPath(String loggerRootPath) {
        this.loggerRootPath = loggerRootPath;
    }

    public String getServerLoggerRootPath() {
        return this.serverLoggerRootPath;
    }

    public void setServerLoggerRootPath(String serverLoggerRootPath) {
        this.serverLoggerRootPath = serverLoggerRootPath;
    }

    public boolean isUseDiskCache() {
        return this.useDiskCache;
    }

    public void setUseDiskCache(boolean useDiskCache) {
        this.useDiskCache = useDiskCache;
    }

    public String getDiskStoreDir() {
        return this.diskStoreDir;
    }

    public void setDiskStoreDir(String diskStoreDir) {
        this.diskStoreDir = diskStoreDir;
    }

    public long getPollingWorkerIntervalMs() {
        return this.pollingWorkerIntervalMs;
    }

    public void setPollingWorkerIntervalMs(long pollingWorkerIntervalMs) {
        this.pollingWorkerIntervalMs = pollingWorkerIntervalMs;
    }

    public int getPrintIfVipDomainChangedSizeLessThan() {
        return this.printIfVipDomainChangedSizeLessThan;
    }

    public void setPrintIfVipDomainChangedSizeLessThan(int printIfVipDomainChangedSizeLessThan) {
        this.printIfVipDomainChangedSizeLessThan = printIfVipDomainChangedSizeLessThan;
    }

    public long getIoErrorIntervalSeconds() {
        return this.ioErrorIntervalSeconds;
    }

    public void setIoErrorIntervalSeconds(long ioErrorIntervalSeconds) {
        this.ioErrorIntervalSeconds = ioErrorIntervalSeconds;
    }

    public long getSuccessParkIntervalMs() {
        return this.successParkIntervalMs;
    }

    public void setSuccessParkIntervalMs(long successParkIntervalMs) {
        this.successParkIntervalMs = successParkIntervalMs;
    }

    public long getUnknownErrorIntervalSeconds() {
        return this.unknownErrorIntervalSeconds;
    }

    public void setUnknownErrorIntervalSeconds(long unknownErrorIntervalSeconds) {
        this.unknownErrorIntervalSeconds = unknownErrorIntervalSeconds;
    }

    public int getHealthCheckSchedulerExecutorFixedPoolSize() {
        return this.healthCheckSchedulerExecutorFixedPoolSize;
    }

    public void setHealthCheckSchedulerExecutorFixedPoolSize(int healthCheckSchedulerExecutorFixedPoolSize) {
        this.healthCheckSchedulerExecutorFixedPoolSize = healthCheckSchedulerExecutorFixedPoolSize;
    }

    public long getHealthCheckMonitorIntervalSec() {
        return this.healthCheckMonitorIntervalSec;
    }

    public void setHealthCheckMonitorIntervalSec(long healthCheckMonitorIntervalSec) {
        this.healthCheckMonitorIntervalSec = healthCheckMonitorIntervalSec;
    }

    public long getTrServerMonitorIntervalSec() {
        return this.trServerMonitorIntervalSec;
    }

    public void setTrServerMonitorIntervalSec(long trServerMonitorIntervalSec) {
        this.trServerMonitorIntervalSec = trServerMonitorIntervalSec;
    }

    public long getSyncServerMonitorIntervalSec() {
        return this.syncServerMonitorIntervalSec;
    }

    public void setSyncServerMonitorIntervalSec(long syncServerMonitorIntervalSec) {
        this.syncServerMonitorIntervalSec = syncServerMonitorIntervalSec;
    }

    public long getSyncWebMonitorIntervalSec() {
        return this.syncWebMonitorIntervalSec;
    }

    public void setSyncWebMonitorIntervalSec(long syncWebMonitorIntervalSec) {
        this.syncWebMonitorIntervalSec = syncWebMonitorIntervalSec;
    }

    public long getMonitorTickDurationSec() {
        return this.monitorTickDurationSec;
    }

    public void setMonitorTickDurationSec(long monitorTickDurationSec) {
        this.monitorTickDurationSec = monitorTickDurationSec;
    }

    public int getTrServerExecutorCorePoolSize() {
        return this.trServerExecutorCorePoolSize;
    }

    public void setTrServerExecutorCorePoolSize(int trServerExecutorCorePoolSize) {
        this.trServerExecutorCorePoolSize = trServerExecutorCorePoolSize;
    }

    public int getTrServerExecutorMaxPoolSize() {
        return this.trServerExecutorMaxPoolSize;
    }

    public void setTrServerExecutorMaxPoolSize(int trServerExecutorMaxPoolSize) {
        this.trServerExecutorMaxPoolSize = trServerExecutorMaxPoolSize;
    }

    public int getTrServerExecutorQueueSize() {
        return this.trServerExecutorQueueSize;
    }

    public void setTrServerExecutorQueueSize(int trServerExecutorQueueSize) {
        this.trServerExecutorQueueSize = trServerExecutorQueueSize;
    }

    public long getChecksumWorkerMonitorIntervalSec() {
        return this.checksumWorkerMonitorIntervalSec;
    }

    public void setChecksumWorkerMonitorIntervalSec(long checksumWorkerMonitorIntervalSec) {
        this.checksumWorkerMonitorIntervalSec = checksumWorkerMonitorIntervalSec;
    }

    public int getHealthCheckTimeoutExecutorFixedPoolSize() {
        return this.healthCheckTimeoutExecutorFixedPoolSize;
    }

    public void setHealthCheckTimeoutExecutorFixedPoolSize(int healthCheckTimeoutExecutorFixedPoolSize) {
        this.healthCheckTimeoutExecutorFixedPoolSize = healthCheckTimeoutExecutorFixedPoolSize;
    }

    public int getHealthCheckTimeoutExecutorQueueSize() {
        return this.healthCheckTimeoutExecutorQueueSize;
    }

    public void setHealthCheckTimeoutExecutorQueueSize(int healthCheckTimeoutExecutorQueueSize) {
        this.healthCheckTimeoutExecutorQueueSize = healthCheckTimeoutExecutorQueueSize;
    }

    public int getHealthCheckBossCount() {
        return this.healthCheckBossCount;
    }

    public void setHealthCheckBossCount(int healthCheckBossCount) {
        this.healthCheckBossCount = healthCheckBossCount;
    }

    public int getHealthCheckWorkerCount() {
        return this.healthCheckWorkerCount;
    }

    public void setHealthCheckWorkerCount(int healthCheckWorkerCount) {
        this.healthCheckWorkerCount = healthCheckWorkerCount;
    }

    public int getCheckServicePort() {
        return this.checkServicePort;
    }

    public void setCheckServicePort(int checkServicePort) {
        this.checkServicePort = checkServicePort;
    }

    public long getRequestTimeLimitMS() {
        return this.requestTimeLimitMS;
    }

    public void setRequestTimeLimitMS(long requestTimeLimitMS) {
        this.requestTimeLimitMS = requestTimeLimitMS;
    }

    public int getPollWorkerExecutorCorePoolSize() {
        return this.pollWorkerExecutorCorePoolSize;
    }

    public void setPollWorkerExecutorCorePoolSize(int pollWorkerExecutorCorePoolSize) {
        this.pollWorkerExecutorCorePoolSize = pollWorkerExecutorCorePoolSize;
    }

    public int getPollWorkerExecutorMaxPoolSize() {
        return this.pollWorkerExecutorMaxPoolSize;
    }

    public void setPollWorkerExecutorMaxPoolSize(int pollWorkerExecutorMaxPoolSize) {
        this.pollWorkerExecutorMaxPoolSize = pollWorkerExecutorMaxPoolSize;
    }

    public int getPollWorkerExecutorQueueSize() {
        return this.pollWorkerExecutorQueueSize;
    }

    public void setPollWorkerExecutorQueueSize(int pollWorkerExecutorQueueSize) {
        this.pollWorkerExecutorQueueSize = pollWorkerExecutorQueueSize;
    }

    public long getIslandCheckIntervalMs() {
        return this.islandCheckIntervalMs;
    }

    public void setIslandCheckIntervalMs(long islandCheckIntervalMs) {
        this.islandCheckIntervalMs = islandCheckIntervalMs;
    }

    public boolean isFrequentPollingControl() {
        return this.frequentPollingControl;
    }

    public void setFrequentPollingControl(boolean frequentPollingControl) {
        this.frequentPollingControl = frequentPollingControl;
    }

    public Boolean isNeedSecurity() {
        return this.needSecurity;
    }

    public void setNeedSecurity(Boolean needSecurity) {
        this.needSecurity = needSecurity;
    }

    public String getSecurityUrl() {
        return this.securityUrl;
    }

    public void setSecurityUrl(String securityUrl) {
        this.securityUrl = securityUrl;
    }

    public String getSecurityWhiteList() {
        return this.securityWhiteList;
    }

    public void setSecurityWhiteList(String securityWhiteList) {
        this.securityWhiteList = securityWhiteList;
    }

    static {
        try {
            ins = new AntVipConfigure();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

