/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.conf;

import com.alipay.drm.client.DRMClient;
import com.alipay.drm.client.api.annotation.BeforeUpdate;
import com.alipay.drm.client.api.annotation.DAttribute;
import com.alipay.drm.client.api.annotation.DResource;
import com.antcloud.antvip.common.conf.AntVipConfigure;
import com.antcloud.antvip.common.log.ConfigLogger;

@DResource(id="DrmSyncControl")
public class DrmSyncControl {
    public static final ConfigLogger LOGGER = ConfigLogger.getInstance();
    private static final DrmSyncControl instance = new DrmSyncControl();
    @DAttribute(dependency=100)
    private long ioErrorIntervalSeconds = AntVipConfigure.getInstance().getIoErrorIntervalSeconds();
    @DAttribute(dependency=100)
    private long successParkIntervalMs = AntVipConfigure.getInstance().getSuccessParkIntervalMs();
    @DAttribute(dependency=100)
    private long unknownErrorIntervalSeconds = AntVipConfigure.getInstance().getUnknownErrorIntervalSeconds();
    @DAttribute(dependency=100)
    private long requestTimeLimitMS = AntVipConfigure.getInstance().getRequestTimeLimitMS();

    private DrmSyncControl() {
        DRMClient.getInstance().register((Object)this, "AntVip-Server");
    }

    @BeforeUpdate
    public void before(String key, Object value) {
        LOGGER.info(DrmSyncControl.class, ">>>>>>>>>>> drm:" + key + ":" + value);
    }

    public static DrmSyncControl getInstance() {
        return instance;
    }

    public long getIoErrorIntervalSeconds() {
        return this.ioErrorIntervalSeconds;
    }

    public long getUnknownErrorIntervalSeconds() {
        return this.unknownErrorIntervalSeconds;
    }

    public long getSuccessParkIntervalMs() {
        return this.successParkIntervalMs;
    }

    public void setIoErrorIntervalSeconds(long ioErrorIntervalSeconds) {
        this.ioErrorIntervalSeconds = ioErrorIntervalSeconds;
    }

    public void setSuccessParkIntervalMs(long successParkIntervalMs) {
        this.successParkIntervalMs = successParkIntervalMs;
    }

    public void setUnknownErrorIntervalSeconds(long unknownErrorIntervalSeconds) {
        this.unknownErrorIntervalSeconds = unknownErrorIntervalSeconds;
    }

    public long getRequestTimeLimitMS() {
        return this.requestTimeLimitMS;
    }

    public void setRequestTimeLimitMS(long requestTimeLimitMS) {
        this.requestTimeLimitMS = requestTimeLimitMS;
    }
}

