/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.enums;

import com.alibaba.common.lang.StringUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public enum DomainType {
    INNER("INNER", "INNER"),
    NORMAL("NORMAL", "NORMAL"),
    GLOBAL("GLOBAL", "GLOBAL");

    private String code;
    private String desc;

    private DomainType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DomainType getByCode(String code) {
        for (DomainType value : DomainType.values()) {
            if (!StringUtil.equals((String)value.code, (String)code)) continue;
            return value;
        }
        return null;
    }

    public static DomainType getByDesc(String desc) {
        for (DomainType value : DomainType.values()) {
            if (!StringUtil.equals((String)value.desc, (String)desc)) continue;
            return value;
        }
        return null;
    }

    public static Map<String, String> toMap() {
        DomainType[] array = DomainType.values();
        HashMap map = Maps.newHashMapWithExpectedSize((int)array.length);
        for (DomainType type : array) {
            map.put(type.code, type.desc);
        }
        return map;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

