/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.log;

import com.antcloud.antvip.common.log.AntvipLoggerFactory;
import org.slf4j.Logger;

public abstract class AbstractLogger {
    private final Logger logger;
    private final String fileName;
    private final String loggerName;

    public AbstractLogger(Class<?> clazz) {
        this.loggerName = clazz.getName();
        this.fileName = clazz.getSimpleName();
        this.logger = AntvipLoggerFactory.getLogger(this.loggerName);
    }

    public void debug(Class<?> clazz, String msgFormat, Object ... args) {
        this.getLogger().debug(String.format("[" + clazz.getSimpleName() + "] " + msgFormat, args));
    }

    public void debug(Class<?> clazz, String msg) {
        this.getLogger().debug("[" + clazz.getSimpleName() + "] " + msg);
    }

    public void info(Class<?> clazz, String msgFormat, Object ... args) {
        this.getLogger().info(String.format("[" + clazz.getSimpleName() + "] " + msgFormat, args));
    }

    public void info(Class<?> clazz, String msg) {
        this.getLogger().info("[" + clazz.getSimpleName() + "] " + msg);
    }

    public void error(Class<?> clazz, Throwable t, String msgFormat, Object ... args) {
        this.getLogger().error(String.format("[" + clazz.getSimpleName() + "] " + msgFormat, args), t);
    }

    public void error(Class<?> clazz, String msg) {
        this.getLogger().error("[" + clazz.getSimpleName() + "] " + msg);
    }

    public void error(Class<?> clazz, String msg, Throwable t) {
        this.getLogger().error("[" + clazz.getSimpleName() + "] " + msg, t);
    }

    public void error(Class<?> clazz, String msgFormat, Object ... args) {
        this.getLogger().error(String.format("[" + clazz.getSimpleName() + "] " + msgFormat, args));
    }

    public void warn(Class<?> clazz, Throwable t, String msgFormat, Object ... args) {
        this.getLogger().warn(String.format("[" + clazz.getSimpleName() + "] " + msgFormat, args), t);
    }

    public void warn(Class<?> clazz, String msg) {
        this.getLogger().warn("[" + clazz.getSimpleName() + "] " + msg);
    }

    public void warn(Class<?> clazz, String msg, Throwable t) {
        this.getLogger().warn("[" + clazz.getSimpleName() + "] " + msg, t);
    }

    public void warn(Class<?> clazz, String msgFormat, Object ... args) {
        this.getLogger().warn(String.format("[" + clazz.getSimpleName() + "] " + msgFormat, args));
    }

    public void debug(String msgFormat, Object ... args) {
        this.getLogger().debug(String.format(msgFormat, args));
    }

    public void debug(String msg) {
        this.getLogger().debug(msg);
    }

    public void info(String msgFormat, Object ... args) {
        this.getLogger().info(String.format(msgFormat, args));
    }

    public void info(String msg) {
        this.getLogger().info(msg);
    }

    public void error(Throwable t, String msgFormat, Object ... args) {
        this.getLogger().error(String.format(msgFormat, args), t);
    }

    public void error(String msg) {
        this.getLogger().error(msg);
    }

    public void error(String msg, Throwable t) {
        this.getLogger().error(msg, t);
    }

    public void error(String msgFormat, Object ... args) {
        this.getLogger().error(String.format(msgFormat, args));
    }

    public void warn(Throwable t, String msgFormat, Object ... args) {
        this.getLogger().warn(String.format(msgFormat, args), t);
    }

    public void warn(String msg) {
        this.getLogger().warn(msg);
    }

    public void warn(String msg, Throwable t) {
        this.getLogger().warn(msg, t);
    }

    public void warn(String msgFormat, Object ... args) {
        this.getLogger().warn(String.format(msgFormat, args));
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getFileName() {
        return this.fileName;
    }
}

