/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.log;

import com.antcloud.antvip.common.log.AbstractLogger;
import com.antcloud.antvip.common.transport.PollingRequest;
import com.antcloud.antvip.common.transport.PollingResponse;

public class SyncServerLogger
extends AbstractLogger {
    private static final SyncServerLogger instance = new SyncServerLogger();

    public static SyncServerLogger getInstance() {
        return instance;
    }

    private SyncServerLogger() {
        super(SyncServerLogger.class);
    }

    public void logOneTimeSyncNameList(String serverHost, PollingRequest request, PollingResponse response) {
        response.setAcceptTime(System.currentTimeMillis());
        this.info("[Synced(One-time) nameList from VipServer(%s)] result=%s, responseTransmitTime=%s, requestWholeElaspedTime=%s", response.isSuccess() ? "success" : response.getPrettyErrorMsg(), serverHost, response.getTransmissionTime(), System.currentTimeMillis() - request.getStartTime());
    }

    public void logOneTimeSyncVipDomain(String domain, String serverHost, PollingRequest request, PollingResponse response) {
        response.setAcceptTime(System.currentTimeMillis());
        this.info("[Synced(One-time) vipDomain(%s) from VipServer(%s)] result=%s, responseTransmitTime=%s, requestWholeElaspedTime=%s", response.isSuccess() ? "success" : response.getPrettyErrorMsg(), domain, serverHost, response.getTransmissionTime(), System.currentTimeMillis() - request.getStartTime());
    }

    public void logOneTimeSyncVipDomains(String serverHost, PollingRequest request, PollingResponse response) {
        response.setAcceptTime(System.currentTimeMillis());
        this.info("[Synced(One-time) vipDomains from VipServer(%s)] result=%s, responseTransmitTime=%s, requestWholeElaspedTime=%s", response.isSuccess() ? "success" : response.getPrettyErrorMsg(), serverHost, response.getTransmissionTime(), System.currentTimeMillis() - request.getStartTime());
    }

    public void logSync(String serverHost, PollingRequest request, PollingResponse response) {
        response.setAcceptTime(System.currentTimeMillis());
        this.info("[Synced(Polling) from VipServer(%s)] result=%s, responseTransmitTime=%s, requestWholeElaspedTime=%s", response.isSuccess() ? "success" : response.getPrettyErrorMsg(), serverHost, response.getTransmissionTime(), System.currentTimeMillis() - request.getStartTime());
    }
}

