/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public enum ProcessorType {
    CLUSTER_LOCK("dispatch", "clusterLock"),
    META_OPS("dispatch", "metaOps"),
    FLOW_EVAL("dispatch", "flowEval"),
    ACL_OPS("dispatch", "aclOps"),
    NAMED_OPS("dispatch", "namedOps"),
    ZONE_OPS("dispatch", "zoneOps"),
    STATIC_OPS("dispatch", "staticOps"),
    DISPATCH_OPS("dispatch", "dispatchOps"),
    CLUSTER_UNLOCK("dispatch", "clusterUnlock"),
    NOOP("dispatch", "noop"),
    SET_FLOW_INFO("gray", "GRAY_FLOW_SET_FLOW_INFO"),
    DISPATCH_FLOW_INFO("gray", "GRAY_FLOW_DISPATCH_FLOW_INFO"),
    BASELINE_SAVER("gray", "GRAY_FLOW_BASELINE_SAVER"),
    BASELINE_RESETTER("gray", "GRAY_FLOW_BASELINE_RESETTER"),
    LOCK_CLUSTER("gray", "LOCK_CLUSTER"),
    UNLOCK_CLUSTER("gray", "UNLOCK_CLUSTER"),
    IDC_DR_STATUS_RESSETTER("gray", "IDC_DR_STATUS_RESSETTER"),
    GRAY_FLOW_DOMAIN_GROUP_BIZ_NAME_UPDATER("gray", "GRAY_FLOW_DOMAIN_GROUP_BIZ_NAME_UPDATER"),
    GRAY_FLOW_DOMAIN_GROUP_BIZ_NAME_RESETER("gray", "GRAY_FLOW_DOMAIN_GROUP_BIZ_NAME_RESETER"),
    GRAY_FLOW_ORDER_CLOSER("gray", "GRAY_FLOW_ORDER_CLOSER");

    private final String type;
    private final String name;

    private ProcessorType(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public static List<String> getAllNamesByType(String type) {
        ArrayList names = Lists.newArrayList();
        for (ProcessorType value : ProcessorType.values()) {
            if (!StringUtils.equals((String)value.getType(), (String)type)) continue;
            names.add(value.getName());
        }
        return names;
    }

    public static ProcessorType getType(String type, String name) {
        for (ProcessorType processorType : ProcessorType.values()) {
            if (!StringUtils.equals((String)processorType.getType(), (String)type) || !StringUtils.equals((String)processorType.getName(), (String)name)) continue;
            return processorType;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }
}

