/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.model;

import com.antcloud.antvip.common.model.VipDomain;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public class RealNode
implements Serializable {
    private static final long serialVersionUID = -3801110359223547182L;
    private transient String domainName;
    private String ip;
    private transient String fqdn;
    private int weight = 1;
    private Integer healthCheckPort = 0;
    private transient boolean enable = false;
    private String zone;
    private volatile Boolean available;
    private long roundTripTime = -1L;
    private String reason;
    private Date lastHealthCheckTime;
    private transient AtomicInteger raisingCount = new AtomicInteger(0);
    private transient AtomicInteger fallingCount = new AtomicInteger(0);
    private transient VipDomain vipDomain;
    private String dataCenter;

    public boolean isFalling() {
        return this.fallingCount.get() > 0;
    }

    public boolean isRaising() {
        return this.raisingCount.get() > 0;
    }

    public boolean raise() {
        try {
            if (this.available == null) {
                this.available = true;
                boolean bl = true;
                return bl;
            }
            if (this.isFalling()) {
                boolean bl = this._markAvailable(true);
                return bl;
            }
            if (this.isRaising()) {
                if (this.raisingCount.incrementAndGet() >= this.vipDomain.getHealthCheckRaise()) {
                    boolean bl = this._markAvailable(true);
                    return bl;
                }
            } else if (!this.available.booleanValue()) {
                if (this.raisingCount.incrementAndGet() >= this.vipDomain.getHealthCheckRaise()) {
                    boolean bl = this._markAvailable(true);
                    return bl;
                }
            } else {
                boolean bl = this._markAvailable(true);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lastHealthCheckTime = new Date();
        }
    }

    public boolean fall() {
        try {
            if (this.available == null) {
                this.available = false;
                boolean bl = true;
                return bl;
            }
            if (this.isFalling()) {
                if (this.fallingCount.incrementAndGet() >= this.vipDomain.getHealthCheckFall()) {
                    boolean bl = this._markAvailable(false);
                    return bl;
                }
            } else {
                if (this.isRaising()) {
                    boolean bl = this._markAvailable(false);
                    return bl;
                }
                if (this.available.booleanValue()) {
                    if (this.fallingCount.incrementAndGet() >= this.vipDomain.getHealthCheckFall()) {
                        boolean bl = this._markAvailable(false);
                        return bl;
                    }
                } else {
                    boolean bl = this._markAvailable(false);
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lastHealthCheckTime = new Date();
        }
    }

    private boolean _markAvailable(boolean _available) {
        this.raisingCount.set(0);
        this.fallingCount.set(0);
        if (this.available != _available) {
            this.available = _available;
            return true;
        }
        return false;
    }

    public String getEffectiveHealtchCheckHost() {
        return this.ip + ":" + this.getEffectiveHealthCheckPort();
    }

    public int getEffectiveHealthCheckPort() {
        return this.healthCheckPort <= 0 ? this.getVipDomain().getHealthCheckDefaultPort() : this.healthCheckPort.intValue();
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getFqdn() {
        return this.fqdn;
    }

    public void setFqdn(String fqdn) {
        this.fqdn = fqdn;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public Integer getHealthCheckPort() {
        return this.healthCheckPort;
    }

    public void setHealthCheckPort(Integer healthCheckPort) {
        this.healthCheckPort = healthCheckPort;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public long getRoundTripTime() {
        return this.roundTripTime;
    }

    public void setRoundTripTime(long roundTripTime) {
        this.roundTripTime = roundTripTime;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public VipDomain getVipDomain() {
        return this.vipDomain;
    }

    public void setVipDomain(VipDomain vipDomain) {
        this.vipDomain = vipDomain;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public Boolean getAvailable() {
        return this.available;
    }

    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public AtomicInteger getRaisingCount() {
        return this.raisingCount;
    }

    public void setRaisingCount(AtomicInteger raisingCount) {
        this.raisingCount = raisingCount;
    }

    public AtomicInteger getFallingCount() {
        return this.fallingCount;
    }

    public void setFallingCount(AtomicInteger fallingCount) {
        this.fallingCount = fallingCount;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isAvailable() {
        return this.available != null && this.available != false;
    }

    public Date getLastHealthCheckTime() {
        return this.lastHealthCheckTime;
    }

    public void setLastHealthCheckTime(Date lastHealthCheckTime) {
        this.lastHealthCheckTime = lastHealthCheckTime;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public void setDataCenter(String dataCenter) {
        this.dataCenter = dataCenter;
    }

    public String toString() {
        return String.format("RealNode [domainName=%s, ip=%s, fqdn=%s, weight=%s, healthCheckPort=%s, enable=%s, zone=%s, available=%s, roundTripTime=%s, reason=%s, lastHealthCheckTime=%s, raisingCount=%s, fallingCount=%s, dataCenter=%s]", this.domainName, this.ip, this.fqdn, this.weight, this.healthCheckPort, this.enable, this.zone, this.available, this.roundTripTime, this.reason, this.lastHealthCheckTime, this.raisingCount, this.fallingCount, this.dataCenter);
    }
}

