/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.serialize;

import com.antcloud.antvip.common.serialize.HessianGzipUtils;
import com.taobao.remoting.serialize.CustomSerialization;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class HessianGzipSerialization
implements CustomSerialization<Object> {
    private ClassLoader loader;

    public HessianGzipSerialization(ClassLoader loader) {
        this.loader = loader;
    }

    public HessianGzipSerialization() {
    }

    public byte[] serialize(byte protocol, Object msg) throws IOException {
        return HessianGzipUtils.serialize(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserialize(byte protocol, byte[] bytes, int idx) throws IOException {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (this.loader != null) {
                Thread.currentThread().setContextClassLoader(this.loader);
            }
            Object object = this._doDeserialize(bytes, idx);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private Object _doDeserialize(byte[] bytes, int idx) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes, idx, bytes.length - idx);
        return HessianGzipUtils.deserialize(input);
    }
}

