/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.transport;

import com.antcloud.antvip.common.exception.AcVipReadTimeoutException;
import com.antcloud.antvip.common.exception.AntVipAuthencationException;
import com.antcloud.antvip.common.exception.AntVipResponseException;
import com.antcloud.antvip.common.model.VipDomain;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class PollingResponse
implements Serializable {
    private static final long serialVersionUID = -8211281791849886491L;
    public static int ERROR_CODE_NOT_READY_FOR_SERVICE = 1;
    public static int ERROR_CODE_SERVER_REJECT = 2;
    public static int ERROR_AUTH = 3;
    public static int ERROR_CODE_EXCEPTION = 4;
    public static int ERROR_SOCKET_READ_TIMEOUT = 5;
    private int errorCode = 0;
    private String errorMsg;
    private List<String> nameList;
    private List<VipDomain> vipDomains;
    private long startTime;
    private long acceptTime;
    private Map<String, Object> extensionParams;

    public long getTransmissionTime() {
        return this.acceptTime - this.startTime;
    }

    public List<String> getNameList() {
        return this.nameList;
    }

    public void setNameList(List<String> nameList) {
        this.nameList = nameList;
    }

    public List<VipDomain> getVipDomains() {
        return this.vipDomains;
    }

    public void setVipDomains(List<VipDomain> vipDomains) {
        this.vipDomains = vipDomains;
    }

    public Map<String, Object> getExtensionParams() {
        return this.extensionParams;
    }

    public void setExtensionParams(Map<String, Object> extensionParams) {
        this.extensionParams = extensionParams;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getAcceptTime() {
        return this.acceptTime;
    }

    public void setAcceptTime(long acceptTime) {
        this.acceptTime = acceptTime;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean isSuccess() {
        return this.errorCode == 0;
    }

    public void checkSuccess() throws AntVipResponseException, AntVipAuthencationException, AcVipReadTimeoutException {
        if (!this.isSuccess()) {
            if (this.errorCode == ERROR_AUTH) {
                throw new AntVipAuthencationException(this.getPrettyErrorMsg());
            }
            if (this.errorCode == ERROR_SOCKET_READ_TIMEOUT) {
                throw new AcVipReadTimeoutException(this.getPrettyErrorMsg());
            }
            throw new AntVipResponseException(this.getPrettyErrorMsg());
        }
    }

    public String getPrettyErrorMsg() {
        return this.errorMsg + "(errorCode:" + this.errorCode + ")";
    }

    public String toString() {
        return String.format("PollingResponse [errorCode=%s, errorMsg=%s, nameList'size=%s, vipDomains'size=%s, startTime=%s, acceptTime=%s, extensionParams=%s]", this.errorCode, this.errorMsg, this.nameList != null ? Integer.valueOf(this.nameList.size()) : null, this.vipDomains != null ? Integer.valueOf(this.vipDomains.size()) : null, this.startTime, this.acceptTime, this.extensionParams);
    }
}

