/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.utils;

import com.alibaba.common.lang.StringUtil;
import com.antcloud.antvip.common.exception.AntVipException;
import com.antcloud.antvip.common.model.RealNode;
import com.antcloud.antvip.common.model.VipDomain;
import com.antcloud.antvip.common.model.VipServer;
import com.antcloud.antvip.common.transport.PollingResponse;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AntVipUtils {
    private static final char SERVER_WEIGHT_SPLIT = ',';

    public static void resolvePollingResponse(PollingResponse vipResponse) {
        List<VipDomain> list;
        if (vipResponse != null && (list = vipResponse.getVipDomains()) != null) {
            for (VipDomain domain : list) {
                AntVipUtils.resolveVipDomain(domain);
            }
        }
    }

    public static void resolveVipDomain(VipDomain domain) {
        List<RealNode> realNodes = domain.getRealNodes();
        if (realNodes != null) {
            for (RealNode realNode : realNodes) {
                realNode.setVipDomain(domain);
            }
        }
    }

    public static void resolveServerList(List<VipServer> resolvedList, List<VipServer> list, String skipHost) {
        if (list != null && !list.isEmpty()) {
            for (VipServer vipServer : list) {
                String host = vipServer.getHost();
                if (StringUtils.isNotBlank((String)skipHost) && StringUtils.equalsIgnoreCase((String)skipHost, (String)host)) continue;
                int weight = vipServer.getWeight();
                VipServer server = new VipServer(host, weight);
                server.setAvaliable(vipServer.isAvaliable());
                resolvedList.add(server);
            }
        }
    }

    public static List<VipServer> parseServerList(List<VipServer> list, List<Object> data, String skipHost) {
        if (data != null && !data.isEmpty()) {
            for (Object item : data) {
                String itemStr = (String)item;
                String[] split = StringUtils.split((String)itemStr, (char)',');
                String host = split[0];
                if (skipHost != null && StringUtil.equalsIgnoreCase((String)host, (String)skipHost)) continue;
                VipServer server = new VipServer(host);
                if (split.length > 1) {
                    int weight = Integer.parseInt(split[1]);
                    server.setWeight(weight);
                }
                list.add(server);
            }
        }
        return list;
    }

    public static String convertToConfigString(VipServer server) {
        return server.getHost() + ',' + server.getWeight();
    }

    public static void mkdirs(File dir) {
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new AntVipException(String.format("Directory(%s) created failed!", dir.getPath()));
            }
        } else if (!dir.isDirectory()) {
            throw new AntVipException(String.format("Directory(%s) exists but it's not directory!", dir.getPath()));
        }
    }
}

