/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.utils;

import com.antcloud.antvip.common.model.RealNode;
import com.antcloud.antvip.common.model.VipDomain;
import com.antcloud.antvip.common.utils.ChecksumUtils;
import com.antcloud.antvip.common.utils.ChecksumUtilsDataCenterVersion;
import com.antcloud.antvip.common.utils.ChecksumUtilsNewVersion;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.jboss.netty.channel.ConnectTimeoutException;

public class AppUtils {
    public static Throwable getLeafCause(Throwable throwable) {
        Throwable cause = throwable.getCause();
        while (cause != null) {
            throwable = cause;
            cause = throwable.getCause();
        }
        return throwable;
    }

    public static boolean isRequestTimeoutException(Throwable throwable) {
        return throwable instanceof TimeoutException || throwable instanceof SocketTimeoutException;
    }

    public static boolean isConnectTimeoutException(Throwable throwable) {
        return throwable instanceof ConnectTimeoutException;
    }

    private static boolean allRealNodeAvailableNotNull(VipDomain vipDomain) {
        List<RealNode> realNodes = vipDomain.getRealNodes();
        if (realNodes != null) {
            for (RealNode node : realNodes) {
                if (node.getAvailable() != null) continue;
                return false;
            }
        }
        return true;
    }

    public static void setupChecksumIfAllRealNodeAvailableNotNull(VipDomain vipDomain) {
        if (AppUtils.allRealNodeAvailableNotNull(vipDomain)) {
            vipDomain.setChecksumForClient(ChecksumUtils.checksumForClient(vipDomain));
            vipDomain.setChecksumForClientNewVersion(ChecksumUtilsNewVersion.checksumForClient(vipDomain));
            vipDomain.setChecksumForClientDataCenter(ChecksumUtilsDataCenterVersion.checksumForClient(vipDomain));
            vipDomain.setChecksumForServer(ChecksumUtils.checksumForServer(vipDomain));
        }
    }
}

