/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.utils;

import com.antcloud.antvip.common.utils.LogUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHashedWheelTimer
extends HashedWheelTimer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncHashedWheelTimer.class);
    private final Executor executor;

    public AsyncHashedWheelTimer(ThreadFactory threadFactory, ThreadNameDeterminer determiner, long tickDuration, TimeUnit unit, int ticksPerWheel, ThreadFactory asyncThreadFactory) {
        super(threadFactory, determiner, tickDuration, unit, ticksPerWheel);
        this.executor = Executors.newCachedThreadPool(asyncThreadFactory);
    }

    public AsyncHashedWheelTimer(ThreadFactory threadFactory, ThreadNameDeterminer determiner, long tickDuration, TimeUnit unit, int ticksPerWheel, Executor asyncExecutor) {
        super(threadFactory, determiner, tickDuration, unit, ticksPerWheel);
        this.executor = asyncExecutor;
    }

    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        return super.newTimeout((TimerTask)new AsyncTimerTask(task), delay, unit);
    }

    class AsyncTimerTask
    implements TimerTask,
    Runnable {
        TimerTask timerTask;
        Timeout timeout;

        public AsyncTimerTask(TimerTask timerTask) {
            this.timerTask = timerTask;
        }

        public void run(Timeout timeout) throws Exception {
            this.timeout = timeout;
            AsyncHashedWheelTimer.this.executor.execute(this);
        }

        @Override
        public void run() {
            try {
                this.timerTask.run(this.timeout);
            }
            catch (Throwable e) {
                LogUtil.error(LOGGER, "Unexpected exception in TimerTask, {}", new Object[]{e});
            }
        }
    }
}

