/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.utils;

import com.antcloud.antvip.common.utils.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class CommonThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonThreadPool.class);
    private static ThreadPoolTaskExecutor threadPool = CommonThreadPool.createThreadPool(10, 50, 3000, "cloudinc-common");

    public static ThreadPoolTaskExecutor getThreadPool(String why) {
        LogUtil.info(LOGGER, "begin apply pool for executing {}", new Object[]{why});
        return threadPool;
    }

    private static ThreadPoolTaskExecutor createThreadPool(int coreSize, int maxSize, int queueCapacity, String tpname) {
        ThreadPoolTaskExecutor threadPool = new ThreadPoolTaskExecutor();
        threadPool.setThreadNamePrefix(tpname);
        threadPool.setMaxPoolSize(maxSize);
        threadPool.setCorePoolSize(coreSize);
        threadPool.setQueueCapacity(queueCapacity);
        threadPool.afterPropertiesSet();
        return threadPool;
    }
}

