/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.utils;

import com.antcloud.antvip.common.exception.AntVipException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class EnvUtil {
    public static final String PROD = "PROD";
    public static final String PRE = "PRE";
    private static String currentEnv;
    private static volatile AtomicBoolean isPre;
    private static final Pattern regexPtn;

    public static InetAddress getInetAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new AntVipException(e);
        }
    }

    public static String getHostIp() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (null == inetAddress) {
                return null;
            }
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new AntVipException(e);
        }
    }

    public static String getLocalHost() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (null == inetAddress) {
                return null;
            }
            return inetAddress.getHostName();
        }
        catch (UnknownHostException e) {
            throw new AntVipException(e);
        }
    }

    public static String getHostnameOrIp() {
        String hostname = EnvUtil.getLocalHost();
        if (StringUtils.isEmpty((String)hostname)) {
            return EnvUtil.getHostIp();
        }
        return hostname;
    }

    public static boolean isPreEvn() throws UnknownHostException {
        if (isPre != null) {
            return isPre.get();
        }
        String hostName = EnvUtil.getPreHost();
        boolean isMatch = regexPtn.matcher(hostName).find();
        isPre = new AtomicBoolean(isMatch);
        return isMatch;
    }

    public static String getPreHost() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static String getEnv() {
        return currentEnv;
    }

    public static boolean isProd() {
        return EnvUtil.isProd(EnvUtil.getEnv());
    }

    public static boolean isProd(String env) {
        return StringUtils.equalsIgnoreCase((String)env, (String)PROD);
    }

    public static boolean isPre() {
        return EnvUtil.isPre(EnvUtil.getEnv());
    }

    public static boolean isPre(String env) {
        return StringUtils.equalsIgnoreCase((String)env, (String)PRE);
    }

    public static String getEnv(String zone) {
        if (StringUtils.isBlank((String)zone)) {
            return "";
        }
        boolean isMatch = StringUtils.contains((String)zone, (String)"99");
        return isMatch ? PRE : PROD;
    }

    static {
        regexPtn = Pattern.compile("-99-\\d+");
        try {
            currentEnv = EnvUtil.isPreEvn() ? PRE : PROD;
        }
        catch (UnknownHostException e) {
            currentEnv = PROD;
        }
    }
}

