/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.utils;

import com.antcloud.antvip.common.log.DefaultLogger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.regex.Pattern;

public class NetworkUtil {
    public static final DefaultLogger LOGGER = DefaultLogger.getInstance();
    private static final String LOCAL_HOST = "127.0.0.1";
    private static final String ANY_HOST = "0.0.0.0";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static volatile InetAddress LOCAL_ADDRESS = null;

    private NetworkUtil() {
    }

    public static synchronized InetAddress getLocalAddress() {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = NetworkUtil.getLocalAddress0();
        return localAddress;
    }

    private static InetAddress getLocalAddress0() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            if (NetworkUtil.isValidAddress(localAddress)) {
                return localAddress;
            }
        }
        catch (Throwable var6) {
            LOGGER.warn(NetworkUtil.class, "Failed to retriving ip address, " + var6.getMessage(), var6);
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    try {
                        NetworkInterface network = interfaces.nextElement();
                        Enumeration<InetAddress> addresses = network.getInetAddresses();
                        if (addresses == null) continue;
                        while (addresses.hasMoreElements()) {
                            try {
                                InetAddress address = addresses.nextElement();
                                if (!NetworkUtil.isValidAddress(address)) continue;
                                return address;
                            }
                            catch (Throwable var5) {
                                LOGGER.warn(NetworkUtil.class, "Failed to retriving ip address, " + var5.getMessage(), var5);
                            }
                        }
                    }
                    catch (Throwable var7) {
                        LOGGER.warn(NetworkUtil.class, "Failed to retriving ip address, " + var7.getMessage(), var7);
                    }
                }
            }
        }
        catch (Throwable var8) {
            LOGGER.warn(NetworkUtil.class, "Failed to retriving ip address, " + var8.getMessage(), var8);
        }
        LOGGER.error("Could not get local host ip address, will use 127.0.0.1 instead.");
        return localAddress;
    }

    private static boolean isValidAddress(InetAddress address) {
        if (address != null && !address.isLoopbackAddress()) {
            String name = address.getHostAddress();
            return name != null && !ANY_HOST.equals(name) && !LOCAL_HOST.equals(name) && IP_PATTERN.matcher(name).matches();
        }
        return false;
    }
}

