/*
 * Decompiled with CFR 0.152.
 */
package com.antcloud.antvip.common.utils;

import com.antcloud.antvip.common.exception.AntVipException;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class ParaCheckUtil {
    public static final Pattern IP_PATTERN = Pattern.compile("([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}");
    public static final Pattern IP_SECTION_PATTERN = Pattern.compile("([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){2}");
    public static final Pattern DOMAIN_PATTERN = Pattern.compile("^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$");

    public static void checkParamNotBlank(String param, String paramName) {
        if (StringUtils.isBlank((String)param)) {
            throw new AntVipException(paramName + " is not allow null!");
        }
    }

    public static void checkParamNotEmpty(Collection<?> param, String paramName) {
        if (param == null || param.isEmpty()) {
            throw new AntVipException(paramName + " is not allow null!");
        }
    }

    public static void checkParamNotEmpty(Map<?, ?> param, String paramName) {
        if (param == null || param.isEmpty()) {
            throw new AntVipException(paramName + " is not allow null!");
        }
    }

    public static void checkParamNotEmpty(Multimap<?, ?> param, String paramName) {
        if (param == null || param.size() == 0) {
            throw new AntVipException(paramName + " is not allow null!");
        }
    }

    public static void checkParamNotEmpty(Object[] array, String paramName) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            throw new AntVipException(paramName + " is not allow null!");
        }
    }

    public static void checkParamNotNull(Object param, String paramName) {
        if (param == null) {
            throw new AntVipException(paramName + " is not allow null!");
        }
    }

    public static void checkParamPositive(Integer param, String paramName) {
        if (param == null || param <= 0) {
            throw new AntVipException(paramName + " is not positive!");
        }
    }

    public static void checkIntScope(Integer param, String paramName, int lower, int upper) {
        if (param == null || param < lower || param > upper) {
            throw new AntVipException(paramName + " is not of bound! Please ensure in [" + lower + "," + upper + "]");
        }
    }

    public static void checkDateScope(Date start, Date end) {
        ParaCheckUtil.checkParamNotNull(start, "gmtStart");
        ParaCheckUtil.checkParamNotNull(end, "gmtEnd");
        if (end.getTime() < start.getTime()) {
            throw new AntVipException("start is erlier than end!");
        }
    }

    public static void checkIpScope(Integer ipSuffix) {
        if (ipSuffix < 1 || ipSuffix > 254) {
            throw new AntVipException(ipSuffix + " is not between 1 and 254!");
        }
    }

    public static void checkIsIp(String ip) {
        ParaCheckUtil.checkParamNotBlank(ip, "ip");
        Matcher mat = IP_PATTERN.matcher(ip);
        if (!mat.matches()) {
            throw new AntVipException(ip + " is not an ip expression!");
        }
    }

    public static void checkIsIpSection(String ipSection) {
        ParaCheckUtil.checkParamNotBlank(ipSection, "ipSection");
        Matcher mat = IP_SECTION_PATTERN.matcher(ipSection);
        if (!mat.matches()) {
            throw new AntVipException(ipSection + " is not an ipSection expression!");
        }
    }

    public static void checkIsDomain(String domainName) {
        ParaCheckUtil.checkParamNotBlank(domainName, "domainName");
        if (domainName.length() > 67) {
            throw new AntVipException("The length of " + domainName + " is too long, ensure length<=67");
        }
    }
}

