/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unionloan.common.util;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class SFtp {
    public static final int SFTP_DEFAULT_PORT = 22;
    private static final String ENCODING_CODE = "UTF-8";
    private static final int BUFFER_SIZE = 2048;
    private static final int TIME_OUT = 30000;
    private Session session = null;
    private ChannelSftp channel = null;
    private String host;
    private int port;
    private String username;
    private String password;
    private String prvKeyPath;

    public SFtp(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public SFtp(String prvKeyPath, String host, int port, String username) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.prvKeyPath = prvKeyPath;
    }

    public void login() throws JSchException {
        JSch jsch = new JSch();
        if (this.prvKeyPath != null) {
            jsch.addIdentity(this.prvKeyPath);
        }
        this.session = this.port > 0 ? jsch.getSession(this.username, this.host, this.port) : jsch.getSession(this.username, this.host);
        if (this.password != null) {
            this.session.setPassword(this.password);
        }
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        this.session.setTimeout(30000);
        this.session.connect();
        this.channel = (ChannelSftp)this.session.openChannel("sftp");
        this.channel.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String pathName, String fileName, InputStream input) throws SftpException {
        String currentDir = this.currentDir();
        if (StringUtils.isEmpty((CharSequence)currentDir)) {
            return false;
        }
        if (!this.changeDir(pathName)) {
            return false;
        }
        try {
            this.channel.put(input, fileName, 0);
            if (!this.existFile(fileName)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.changeDir(currentDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String pathName, String fileName, String localFile) throws SftpException {
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName)) {
            return false;
        }
        try {
            this.channel.put(localFile, fileName, 0);
            if (!this.existFile(fileName)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.changeDir(currentDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String remotePath, String fileName, String localPath) throws SftpException {
        String currentDir = this.currentDir();
        if (!this.changeDir(remotePath)) {
            return false;
        }
        try {
            String localFilePath = localPath + File.separator + fileName;
            this.channel.get(fileName, localFilePath);
            File localFile = new File(localFilePath);
            if (!localFile.exists()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.changeDir(currentDir);
        }
    }

    public boolean changeDir(String pathName) throws SftpException {
        if (pathName == null || pathName.trim().equals("")) {
            return false;
        }
        this.channel.cd(pathName.replaceAll("\\\\", "/"));
        return true;
    }

    public String[] lsFiles() throws SftpException {
        return this.list(Filter.FILE);
    }

    public String[] lsFiles(String pathName) throws SftpException {
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName)) {
            return new String[0];
        }
        String[] result = this.list(Filter.FILE);
        if (!this.changeDir(currentDir)) {
            return new String[0];
        }
        return result;
    }

    public boolean existFile(String name) throws SftpException {
        return this.exist(this.lsFiles(), name);
    }

    public boolean existFile(String path, String name) throws SftpException {
        return this.exist(this.lsFiles(path), name);
    }

    public String currentDir() throws SftpException {
        return this.channel.pwd();
    }

    public boolean delFile(String filePath, String fileName) throws SftpException {
        if (StringUtils.isEmpty((CharSequence)filePath) || StringUtils.isEmpty((CharSequence)fileName)) {
            return false;
        }
        if (!this.existFile(filePath, fileName)) {
            return true;
        }
        this.channel.rm(filePath + "/" + fileName);
        return true;
    }

    public boolean delFile(String fileName) throws SftpException {
        if (fileName == null || fileName.trim().equals("")) {
            return false;
        }
        if (!this.existFile(fileName)) {
            return true;
        }
        this.channel.rm(fileName);
        return true;
    }

    public void logout() {
        if (this.channel != null) {
            this.channel.quit();
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    private String[] list(Filter filter) throws SftpException {
        Vector list = null;
        list = this.channel.ls(this.channel.pwd());
        ArrayList<String> resultList = new ArrayList<String>();
        for (ChannelSftp.LsEntry entry : list) {
            if (!this.filter(entry, filter)) continue;
            resultList.add(entry.getFilename());
        }
        return resultList.toArray(new String[0]);
    }

    private boolean filter(ChannelSftp.LsEntry entry, Filter f) {
        if (f.equals((Object)Filter.ALL)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..");
        }
        if (f.equals((Object)Filter.FILE)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..") && !entry.getAttrs().isDir();
        }
        if (f.equals((Object)Filter.DIR)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..") && entry.getAttrs().isDir();
        }
        return false;
    }

    private String homeDir() {
        try {
            return this.channel.getHome();
        }
        catch (SftpException e) {
            return "/";
        }
    }

    private boolean exist(String[] strArr, String str) {
        if (strArr == null || strArr.length == 0) {
            return false;
        }
        if (str == null || str.trim().equals("")) {
            return false;
        }
        for (String s : strArr) {
            if (!s.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public void createIfNotExist(String dir) {
        try {
            this.channel.cd(dir);
        }
        catch (SftpException e) {
            try {
                this.channel.mkdir(dir);
            }
            catch (SftpException ee) {
                ee.printStackTrace();
            }
        }
    }

    private static enum Filter {
        ALL,
        FILE,
        DIR;

    }
}

