/*
 * Decompiled with CFR 0.152.
 */
package com.geotmt.client;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class HttpClient {
    private static ThreadLocal<Integer> httpState = new ThreadLocal();
    private static ThreadLocal<String> httpCookieString = new ThreadLocal();

    public static void removeThreadLocal() {
        httpState.remove();
        httpCookieString.remove();
    }

    public static Integer getHttpState() {
        Integer state = httpState.get();
        return state;
    }

    public static String getHttpCookieString() {
        String cookies = httpCookieString.get();
        return cookies;
    }

    public static void main(String[] args) {
        try {
            System.out.println(HttpClient.getRs("http://127.0.0.1:8080/taskmeta/getview/web/o/login", "username=test1&password=test1", "UTF-8", "UTF-8", "POST", 10000, 10000, null));
            String cookies = httpCookieString.get();
            System.out.println(cookies);
            System.out.println(HttpClient.getRs("http://127.0.0.1:8080/taskmeta/getview/web/u/getuseraction", "username=test1&password=test1&uno=200002&dsign=1", "UTF-8", "UTF-8", "POST", 10000, 10000, null, cookies, null, "", ""));
            cookies = httpCookieString.get();
            System.out.println(cookies);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String readCookies(URLConnection url_con) {
        StringBuilder cookieSb = new StringBuilder();
        List<String> cookieList = url_con.getHeaderFields().get("Set-Cookie");
        if (cookieList != null) {
            for (String cookie : cookieList) {
                int p;
                if (cookie == null || "".equals(cookie) || (p = cookie.indexOf("=")) <= 0) continue;
                String key = cookie.substring(0, p);
                int vp = cookie.indexOf(";");
                if (vp <= 0) {
                    vp = cookie.length();
                }
                String value = cookie.substring(p + 1, vp);
                cookieSb.append(key).append("=").append(value).append(";");
            }
        }
        return cookieSb.toString();
    }

    public static String getRs(String path, String params, String reqencoding, String respencoding, String requestMethod, Integer httpConnectTimeout, Integer httpReadTimeout, Map<String, String> headerMap) {
        return HttpClient.getRs(path, params, reqencoding, respencoding, requestMethod, httpConnectTimeout, httpReadTimeout, headerMap, null, null, "", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRs(String path, String params, String reqencoding, String respencoding, String requestMethod, Integer httpConnectTimeout, Integer httpReadTimeout, Map<String, String> headerMap, String cookies, Proxy proxy, String proxyUser, String proxyPwd) {
        long a = System.currentTimeMillis();
        httpState.set(null);
        httpCookieString.set(null);
        URL url = null;
        URLConnection connection = null;
        try {
            Set<String> set;
            if (headerMap == null || !headerMap.containsKey("httpStreamStr")) {
                params = HttpClient.trsPara(params, reqencoding);
            }
            url = new URL(path);
            if (proxy != null) {
                connection = url.openConnection(proxy);
                if (!"".equals(proxyUser) && proxyUser != null) {
                    String headerkey = "Proxy-Authorization";
                    String headerValue = "Basic " + new String(Base64.getEncoder().encode((proxyUser + ":" + proxyPwd).getBytes("UTF-8")), "UTF-8");
                    connection.setRequestProperty(headerkey, headerValue);
                }
            } else {
                connection = url.openConnection();
            }
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
                TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
                SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
                sslContext.init(null, tm, new SecureRandom());
                SSLSocketFactory ssf = sslContext.getSocketFactory();
                ((HttpsURLConnection)connection).setSSLSocketFactory(ssf);
                ((HttpsURLConnection)connection).setRequestMethod(requestMethod);
            } else {
                ((HttpURLConnection)connection).setRequestMethod(requestMethod);
            }
            connection.setRequestProperty("Connection", "close");
            connection.setRequestProperty("Accept-Encoding", "gzip,deflate");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36");
            if (cookies != null && !"".equals(cookies) && !"null".equalsIgnoreCase(cookies)) {
                connection.setRequestProperty("Cookie", cookies);
            }
            if (headerMap != null && (set = headerMap.keySet()) != null) {
                for (String k : set) {
                    connection.setRequestProperty(k, headerMap.get(k));
                }
            }
            if (httpConnectTimeout == null) {
                httpConnectTimeout = 10000;
            }
            connection.setConnectTimeout(httpConnectTimeout);
            if (httpReadTimeout == null) {
                httpReadTimeout = 10000;
            }
            connection.setReadTimeout(httpReadTimeout);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.connect();
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            if (headerMap != null && headerMap.containsKey("httpStreamStr")) {
                params = params + "";
                out.write(params.getBytes(reqencoding), 0, params.length());
            } else {
                out.writeBytes(params);
            }
            out.flush();
            out.close();
            BufferedReader reader = null;
            String encode = "";
            try {
                InputStream in = null;
                if (connection.getContentEncoding() != null && !"".equals(connection.getContentEncoding()) && !"null".equals(connection.getContentEncoding()) && (encode = connection.getContentEncoding().toLowerCase()) != null && encode.indexOf("gzip") >= 0) {
                    in = new GZIPInputStream(connection.getInputStream());
                }
                if (null == in) {
                    in = connection.getInputStream();
                }
                reader = new BufferedReader(new InputStreamReader(in, respencoding));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            StringBuilder buffer = new StringBuilder();
            String line = "";
            String rs = "";
            if (reader != null) {
                while ((line = reader.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
                reader.close();
                if (buffer.length() > 1) {
                    rs = buffer.substring(0, buffer.length() - 1);
                }
            }
            int state = 0;
            state = connection instanceof HttpsURLConnection ? ((HttpsURLConnection)connection).getResponseCode() : ((HttpURLConnection)connection).getResponseCode();
            httpState.set(state);
            String ck = HttpClient.readCookies(connection);
            httpCookieString.set(ck);
            System.out.println(path + "?" + params + "@" + headerMap + "@" + cookies + ";\u9418\u8235\ufffd\u4f7a\u721c:" + state + ";gzip:" + encode + ";\u6769\u65bf\u6d16\u7f01\u64b4\u7049:" + rs + ";cookies:" + ck + "##\u9470\u6941\u6902:" + (System.currentTimeMillis() - a));
            String string = rs;
            return string;
        }
        catch (Exception e) {
            System.out.println(path + "?" + params + "@" + headerMap + "@" + cookies);
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).disconnect();
            } else {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    public static String trsPara(String params, String reqencoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (params == null || "".equals(params)) {
            return "";
        }
        String[] ps = params.split("&");
        int l = ps.length;
        for (int i = 0; i < l; ++i) {
            String[] ps1;
            if (ps[i] == null || (ps1 = ps[i].split("=")).length != 2) continue;
            sb.append("&").append(ps1[0]).append("=").append(URLEncoder.encode(ps1[1], reqencoding));
        }
        return sb.length() <= 1 ? "" : sb.toString().substring(1);
    }

    private static class MyX509TrustManager
    implements X509TrustManager {
        X509TrustManager sunJSSEX509TrustManager;

        MyX509TrustManager() throws Exception {
            KeyStore ks = KeyStore.getInstance("JKS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            tmf.init(ks);
            TrustManager[] tms = tmf.getTrustManagers();
            for (int i = 0; i < tms.length; ++i) {
                if (!(tms[i] instanceof X509TrustManager)) continue;
                this.sunJSSEX509TrustManager = (X509TrustManager)tms[i];
                return;
            }
            throw new Exception("Couldn\u9225\u6a9b initialize");
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.sunJSSEX509TrustManager.checkClientTrusted(chain, authType);
            }
            catch (CertificateException excep) {
                excep.printStackTrace();
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.sunJSSEX509TrustManager.checkServerTrusted(chain, authType);
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.sunJSSEX509TrustManager.getAcceptedIssuers();
        }
    }
}

