/*
 * Decompiled with CFR 0.152.
 */
package com.geotmt.client;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class RSAUtils {
    private static final Provider PROVIDER = new BouncyCastleProvider();
    private static final int KEY_SIZE = 2048;
    private static KeyPair staticKeyPair;

    public static int getKeySize() {
        return 2048;
    }

    private RSAUtils() {
    }

    public static KeyPair generateKeyPair() {
        long st = System.currentTimeMillis();
        KeyPair keyPair = null;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", PROVIDER);
            keyPairGenerator.initialize(2048, new SecureRandom());
            keyPair = keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        System.out.printf("\u9422\u71b8\u579a\u95c5\u5fd4\u6e80\u934f\ue102\ue746\u95bd\u30e8\ufffd\u6941\u6902:" + (System.currentTimeMillis() - st), new Object[0]);
        return keyPair;
    }

    public static KeyPair getKeyPair(String RSAmodulus, String RSApublicExponent, String RSAprivateExponent) {
        long st = System.currentTimeMillis();
        RSAPublicKey publicKey = null;
        if (RSApublicExponent != null && !"".equals(RSApublicExponent)) {
            publicKey = RSAUtils.getPublicKey(RSAmodulus, RSApublicExponent);
        }
        RSAPrivateKey privateKey = null;
        if (RSAprivateExponent != null && !"".equals(RSAprivateExponent)) {
            privateKey = RSAUtils.getPrivateKey(RSAmodulus, RSAprivateExponent);
        }
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        System.out.printf("\u9422\u71b8\u579a\u9365\u54c4\u757e\u934f\ue102\ue746\u95bd\u30e8\ufffd\u6941\u6902:" + (System.currentTimeMillis() - st), new Object[0]);
        return keyPair;
    }

    public static KeyPair getKeyPair() {
        if (staticKeyPair != null) {
            return staticKeyPair;
        }
        String RSAmodulus = "17590361768550206211304296020909443672497991496756109773322252259013465286845579413752496184027248059820980704679469737118666075144537820150739324451689607094439709077353019826775495958346915123823636420712765173032060048441941353150612472037329023471233201526271263321748209433499510445056447198407665583194128929575382802662715348893612504772549730627496131956857340581560167388183512266198528481499308939895214866963512452810966483935049796734695702115469855329855747438056741212320013011404385827781345796864627964307106735940995903236433032449374592345961492652542537539286775674624957345808007153510920388584373";
        String RSApublicExponent = "65537";
        String RSAprivateExponent = "";
        staticKeyPair = RSAUtils.getKeyPair(RSAmodulus, RSApublicExponent, RSAprivateExponent);
        return staticKeyPair;
    }

    public static byte[] encrypt(Key publicKey, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance("RSA", PROVIDER);
            cipher.init(1, publicKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encrypt(Key publicKey, String text) {
        long st = System.currentTimeMillis();
        byte[] data = null;
        try {
            data = RSAUtils.encrypt(publicKey, text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String encryptValue = data != null ? RSAUtils.parseByteToHexStr(data) : null;
        System.out.printf("\u9354\u72b2\u7611:" + text + ";\u9470\u6941\u6902:" + (System.currentTimeMillis() - st), new Object[0]);
        return encryptValue;
    }

    public static byte[] decrypt(Key privateKey, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance("RSA", (Provider)new BouncyCastleProvider());
            cipher.init(2, privateKey);
            int blockSize = cipher.getBlockSize();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(64);
            int j = 0;
            while (data.length - j * blockSize > 0) {
                bout.write(cipher.doFinal(data, j * blockSize, blockSize));
                ++j;
            }
            return bout.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decrypt(Key privateKey, String text) {
        long st = System.currentTimeMillis();
        String decryptValue = null;
        byte[] data = RSAUtils.decrypt(privateKey, RSAUtils.hexStringToBytes(text));
        try {
            decryptValue = data != null ? new String(data, "UTF-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.out.printf("\u7459\uff45\u7611:" + text + ";\u9470\u6941\u6902:" + (System.currentTimeMillis() - st), new Object[0]);
        return decryptValue;
    }

    public static String parseByteToHexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(RSAUtils.charToByte(hexChars[pos]) << 4 | RSAUtils.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static RSAPublicKey getPublicKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RSAPrivateKey getPrivateKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(b1, b2);
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        KeyPair keyPair = RSAUtils.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        System.err.println("publicKey.getModulus:" + publicKey.getModulus());
        System.err.println("publicKey.getPublicExponent:" + publicKey.getPublicExponent());
        System.err.println("privateKey.getPrivateExponent:" + privateKey.getPrivateExponent());
        String miwen = RSAUtils.encrypt((Key)publicKey, "\u6d63\u72b2\u30bd\u6fb6\u0442\u5a07\u68e3\u55d7\u6431\u752f\u581d\u3047\u7487\u6751\u5f5e\u7487\ufffd hgfghf655766");
        System.out.println(miwen);
        String jiemi = RSAUtils.decrypt((Key)privateKey, miwen);
        System.out.println(jiemi);
        System.out.println(publicKey.getEncoded().length + "ddddddddddddddddddddd");
        System.out.println(publicKey);
        miwen = RSAUtils.encrypt((Key)privateKey, "{\"code\":\"200\",\"data\":{\"tokenId\":\"3b5335396092dbf2da0012808a47d0df7\",\"digitalSignatureKey\":\"0f3hcwpqlqkmnw1\"},\"msg\":\"\u93b4\u612c\u59db\",\"tokenId\":\"3b5335396092dbf2da0012808a47d0df7\"}");
        System.out.println(miwen);
        jiemi = RSAUtils.decrypt((Key)publicKey, miwen);
        System.out.println(jiemi);
        String publicKeygetModulus = "146092808730320144735729361737259771395235784649397849347545828067983277664773638462655578460422052152852205026953787284472096786817652688013074920919852351549938104513323543701126867458745130312737974044654218992287837756506147223536240986269365483829624306509395462000876837761910186773929621438806709092917";
        String publicKeygetPublicExponent = "65537";
        String privateKeygetPrivateExponent = "42797745316590879331999756107140246746374289782623393039405715139191768739582054180760859527620168443514495389054820362155420391688849260069320008647637896635466193738861220089120152377950332958757102733242003174861734744105050029562777024551670221668038025921938206071392308124916602082924998644417338384865";
        KeyPair keyPair1 = RSAUtils.getKeyPair(publicKeygetModulus, publicKeygetPublicExponent, privateKeygetPrivateExponent);
        publicKey = (RSAPublicKey)keyPair1.getPublic();
        privateKey = (RSAPrivateKey)keyPair1.getPrivate();
        String miwen1 = RSAUtils.encrypt((Key)publicKey, "adminahgsdvghasgdhagsdhjgasyudgasudbjkasbdhjasdbjhasbdhasjdvasfdasgvgdhv");
        System.out.println("11111111:" + miwen1);
        String jiemi1 = RSAUtils.decrypt((Key)privateKey, miwen1);
        System.out.println(jiemi1);
    }
}

