/*
 * Decompiled with CFR 0.152.
 */
package com.geotmt.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ReadConf {
    private static Map<String, Properties> properties = new HashMap<String, Properties>();
    private static String baseDir = "" + File.separator;

    public static String getProperty(String key) {
        return ReadConf.getProperty("geoclient.properties", key);
    }

    public static String getProperty(String propertiesFile, String key) {
        ReadConf.initProperties(propertiesFile, "UTF-8");
        return properties.get(baseDir + propertiesFile).getProperty(key);
    }

    public static void initProperties(String propertiesFile, String charset) {
        Properties prop = properties.get(baseDir + propertiesFile);
        if (prop == null) {
            prop = ReadConf.getProperties(propertiesFile, charset);
            properties.put(baseDir + propertiesFile, prop);
        }
    }

    public static Properties getPropertiesInCache(String propertiesFile, String charset) {
        ReadConf.initProperties(propertiesFile, charset);
        return properties.get(baseDir + propertiesFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String propertiesFile, String charset) {
        InputStream is = null;
        Properties p = null;
        InputStreamReader insReader = null;
        try {
            if (!propertiesFile.startsWith(File.separator)) {
                String classPath = Thread.currentThread().getContextClassLoader().getResource("").getPath();
                propertiesFile = classPath + baseDir + propertiesFile;
            }
            is = new FileInputStream(propertiesFile);
            insReader = new InputStreamReader(is, charset);
            p = new Properties();
            p.load(insReader);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (insReader != null) {
                try {
                    insReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return p;
    }

    public static String getBaseDir() {
        return baseDir;
    }

    public static void setBaseDir(String baseDir) {
        ReadConf.baseDir = baseDir;
    }

    public static void main(String[] args) {
        System.out.println(ReadConf.getProperty("ClientID"));
    }
}

