/*
 * Decompiled with CFR 0.152.
 */
package com.geotmt.client;

import com.geotmt.client.AES;
import com.geotmt.client.AES2;
import com.geotmt.client.DES;
import com.geotmt.client.RSAUtils;
import com.geotmt.client.TripleDES;
import com.geotmt.client.XOREncrypt;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;

public class Secret {
    public static String encrypt(String encryptionType, String content, String encryptionKey) {
        if (encryptionType.startsWith("DESede")) {
            content = TripleDES.encrypt(content, encryptionKey);
        } else if (encryptionType.startsWith("DES")) {
            content = DES.encrypt(content, encryptionKey);
        } else if (encryptionType.startsWith("AES2")) {
            content = AES2.encrypt(content, encryptionKey);
        } else if (encryptionType.startsWith("AES")) {
            content = AES.encrypt(content, encryptionKey);
        } else if (encryptionType.startsWith("XOR")) {
            content = XOREncrypt.encrypt(content, encryptionKey);
        } else if (encryptionType.startsWith("RSA")) {
            String[] rsakey = encryptionKey.split(";");
            String publicKeygetModulus = rsakey[0];
            String publicKeygetPublicExponent = rsakey[1];
            String privateKeygetPrivateExponent = rsakey[2];
            KeyPair keyPair = RSAUtils.getKeyPair(publicKeygetModulus, publicKeygetPublicExponent, privateKeygetPrivateExponent);
            content = RSAUtils.encrypt((Key)keyPair.getPublic(), content);
        }
        return content;
    }

    public static String decrypt(String encryptionType, String content, String encryptionKey) {
        if (encryptionType.startsWith("DESede")) {
            content = TripleDES.decrypt(content, encryptionKey);
        } else if (encryptionType.startsWith("DES")) {
            content = DES.decrypt(content, encryptionKey);
        } else if (encryptionType.startsWith("AES2")) {
            content = AES2.decrypt(content, encryptionKey);
        } else if (encryptionType.startsWith("AES")) {
            content = AES.decrypt(content, encryptionKey);
        } else if (encryptionType.startsWith("XOR")) {
            content = XOREncrypt.decrypt(content, encryptionKey);
        } else if (encryptionType.startsWith("RSA")) {
            String[] rsakey = encryptionKey.split(";");
            String publicKeygetModulus = rsakey[0];
            String publicKeygetPublicExponent = rsakey[1];
            String privateKeygetPrivateExponent = rsakey[2];
            KeyPair keyPair = RSAUtils.getKeyPair(publicKeygetModulus, publicKeygetPublicExponent, privateKeygetPrivateExponent);
            content = RSAUtils.decrypt((Key)keyPair.getPrivate(), content);
        }
        return content;
    }

    public static String md5(String source) {
        StringBuffer sb = new StringBuffer(32);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(source.getBytes("utf-8"));
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return sb.toString();
    }
}

