/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.core.context.impl;

import com.hundsun.t2sdk.interfaces.core.channel.IServiceClient;
import com.hundsun.t2sdk.interfaces.core.context.IEventContext;
import com.hundsun.t2sdk.interfaces.core.context.IServiceContext;
import com.hundsun.t2sdk.interfaces.core.event.IDatasetsFactory;
import com.hundsun.t2sdk.interfaces.core.event.IEventFactory;
import com.hundsun.t2sdk.interfaces.share.event.IEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonEventContext
implements IEventContext {
    private IEvent event = null;
    private IServiceContext serviceContext = null;
    private String serviceId = null;
    private String currentStep;

    public CommonEventContext(String serviceId, IEvent event, IServiceContext serviceContext) {
        this.serviceId = serviceId;
        this.event = event;
        this.serviceContext = serviceContext;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public IEventFactory getEventFactory() {
        return this.serviceContext.getEventFactory();
    }

    @Override
    public IDatasetsFactory getDatasetsFactory() {
        return this.serviceContext.getDatasetsFactory();
    }

    @Override
    public IServiceClient getServiceClient() {
        return this.serviceContext.getServiceClient();
    }

    @Override
    public int registerService(Object service, String serviceKey, String serviceName, Class<?> clz) {
        return this.serviceContext.registerService(service, serviceKey, serviceName, clz);
    }

    @Override
    public void setReturnCode(int returnCode) {
        this.event.setReturnCode(returnCode);
    }

    @Override
    public Object getService(String serviceKey, String serviceName) {
        return this.serviceContext.getService(serviceKey, serviceName);
    }

    @Override
    public Object getService(String pluginName, String serviceName, Class<?> clz) {
        return this.serviceContext.getService(pluginName, serviceName, clz);
    }

    @Override
    public String getErrorInfo() {
        return this.event.getErrorInfo();
    }

    @Override
    public String getErrorNo() {
        return this.event.getErrorNo();
    }

    @Override
    public int getReturnCode() {
        return this.event.getReturnCode();
    }

    @Override
    public void setError(String errorNo, String errorInfo) {
        if (this.event.getReturnCode() == 0) {
            this.event.setReturnCode(-1);
        }
        this.event.setErrorCode(errorNo, errorInfo);
    }

    @Override
    public IEvent getEvent() {
        return this.event;
    }

    @Override
    public Object getEventAttribute(String tagName) {
        return this.event.getAttributeValue(tagName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentStep(String currentStep) {
        IEvent iEvent = this.event;
        synchronized (iEvent) {
            this.currentStep = currentStep;
        }
    }

    @Override
    public String getCurrentStep() {
        return this.currentStep;
    }
}

