/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.core.context.impl;

import com.hundsun.t2sdk.common.core.context.ContextUtil;
import com.hundsun.t2sdk.common.core.event.DatasetsFactory;
import com.hundsun.t2sdk.common.core.event.EventFactory;
import com.hundsun.t2sdk.interfaces.core.channel.IServiceClient;
import com.hundsun.t2sdk.interfaces.core.context.IServiceContext;
import com.hundsun.t2sdk.interfaces.core.event.IDatasetsFactory;
import com.hundsun.t2sdk.interfaces.core.event.IEventFactory;
import com.hundsun.t2sdk.interfaces.pluginFramework.IPluginService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonServiceContext
implements IServiceContext {
    private final IEventFactory eventFactory;
    private final IDatasetsFactory datasetsFactory;
    private final ConcurrentMap<String, ConcurrentMap<String, Object>> services = new ConcurrentHashMap<String, ConcurrentMap<String, Object>>();

    public CommonServiceContext() {
        this.eventFactory = new EventFactory();
        this.datasetsFactory = new DatasetsFactory();
        this.registerService(this.eventFactory, "service", "jres.eventFactory", null);
        this.registerService(this.datasetsFactory, "service", "jres.datasetsFactory", null);
    }

    @Override
    public IEventFactory getEventFactory() {
        return this.eventFactory;
    }

    @Override
    public IDatasetsFactory getDatasetsFactory() {
        return this.datasetsFactory;
    }

    @Override
    public IServiceClient getServiceClient() {
        return (IServiceClient)this.getService("service", "jres.serviceClient", IServiceClient.class);
    }

    @Override
    public Object getService(String serviceKey, String serviceName) {
        IPluginService framework;
        Object service;
        Map map = (Map)this.services.get(serviceKey);
        if (map != null && (service = map.get(serviceName)) != null) {
            return service;
        }
        if (("plugin".equals(serviceKey) || serviceKey == null) && (framework = ContextUtil.getFramework()) != null) {
            IPluginService plugin = framework.queryService(serviceName);
            return plugin;
        }
        return null;
    }

    @Override
    public Object getService(String serviceKey, String serviceName, Class<?> clz) {
        Object obj = this.getService(serviceKey, serviceName);
        if (obj != null && clz.isInstance(obj)) {
            return obj;
        }
        return null;
    }

    @Override
    public int registerService(Object service, String serviceKey, String serviceName, Class<?> clz) {
        ConcurrentHashMap<String, Object> map = (ConcurrentHashMap<String, Object>)this.services.get(serviceKey);
        if (map == null) {
            map = new ConcurrentHashMap<String, Object>();
            this.services.put(serviceKey, map);
        }
        map.put(serviceName, service);
        return 0;
    }
}

