/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.core.pool;

import com.hundsun.t2sdk.common.core.pool.Queue;
import com.hundsun.t2sdk.common.core.pool.QueueService;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingQueuePool<E> {
    private volatile int lastShortestQueue = 0;
    private volatile int lastLongestQueue = 0;
    private volatile boolean isWork = true;
    private int queueCount = 0;
    private final List<Queue<E>> queues = new ArrayList<Queue<E>>();
    private final List<Long> rejectCounts = new ArrayList<Long>();
    private final List<Long> firstRejectTime = new ArrayList<Long>();

    public int currentShortestQueue() {
        int min = Integer.MAX_VALUE;
        int queueNo = -1;
        int currentQueueSize = 0;
        int queueCount = this.queueCount;
        int lastShortestQueue = this.lastShortestQueue;
        for (int i = 1; i <= queueCount; ++i) {
            int index = (i + lastShortestQueue) % queueCount;
            Queue<E> queue = this.queues.get(index);
            currentQueueSize = queue.size();
            if (currentQueueSize == 0) {
                queueNo = index;
                break;
            }
            if (currentQueueSize >= min) continue;
            min = currentQueueSize;
            queueNo = index;
        }
        this.lastShortestQueue = queueNo;
        return queueNo;
    }

    public int currentLongestQueue() {
        int min = 0;
        int queueNo = -1;
        int queueCount = this.queueCount;
        int lastLongestQueue = this.lastLongestQueue;
        for (int i = 1; i <= queueCount; ++i) {
            int index = (i + lastLongestQueue) % queueCount;
            Queue<E> queue = this.queues.get(index);
            int currentQueueSize = queue.size();
            if (currentQueueSize <= min) continue;
            min = currentQueueSize;
            queueNo = index;
        }
        if (queueNo != -1) {
            this.lastLongestQueue = queueNo;
        }
        return queueNo;
    }

    public Queue<E> newQueue(int queueSize) {
        Queue queue = QueueService.createQueue(queueSize);
        this.queues.add(queue);
        this.rejectCounts.add(0L);
        this.firstRejectTime.add(0L);
        ++this.queueCount;
        return queue;
    }

    public Queue<E> getQueue(int index) {
        if (index < 0 || index >= this.queueCount) {
            return null;
        }
        return this.queues.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToQueue(E element) {
        boolean result = false;
        if (this.isWork) {
            int queueNo = this.currentShortestQueue();
            if (queueNo == -1) {
                return false;
            }
            Queue<E> queue = this.queues.get(queueNo);
            result = queue.offer(element);
            if (!result) {
                Queue<E> queue2 = queue;
                synchronized (queue2) {
                    long recount = this.rejectCounts.get(queueNo);
                    this.rejectCounts.set(queueNo, recount + 1L);
                    long reTime = this.firstRejectTime.get(queueNo);
                    if (reTime == 0L) {
                        this.firstRejectTime.set(queueNo, System.nanoTime());
                    }
                }
            }
        }
        return result;
    }

    public synchronized void start() {
        this.clear();
        this.isWork = true;
    }

    public synchronized void notifyToStop() {
        this.isWork = false;
    }

    protected void clear() {
        this.queues.clear();
        this.rejectCounts.clear();
        this.firstRejectTime.clear();
        this.lastShortestQueue = 0;
        this.lastLongestQueue = 0;
        this.queueCount = 0;
    }

    public List<Long> getRejectCounts() {
        return this.rejectCounts;
    }

    public List<Long> getFirstRejectTime() {
        return this.firstRejectTime;
    }

    public int size() {
        return this.queues.size();
    }
}

