/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.core.pool;

import com.hundsun.t2sdk.common.core.pool.BlockingQueuePool;
import com.hundsun.t2sdk.common.core.pool.IProcessExceptionHandler;
import com.hundsun.t2sdk.common.core.pool.Queue;
import com.hundsun.t2sdk.common.core.pool.Task;
import com.hundsun.t2sdk.interfaces.core.context.IEventContext;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestlessThread
extends Thread {
    public static final int NOT_PREPARE = -1;
    public static final int IDLE = 0;
    public static final int PROCESSING = 1;
    public static final int DEAD = 2;
    protected volatile boolean canStop = false;
    protected volatile boolean isActive = true;
    protected final long CHECK_OWN_QUEUE_INTERVAL = 5000L;
    protected final long CHECK_OTHER_QUEUE_INTERVAL = 5L;
    protected BlockingQueuePool<Task> queuePool;
    protected Queue<Task> myQueue;
    protected long processCount = 0L;
    protected long procErrorCount = 0L;
    protected int status = -1;
    protected String processingName;
    protected IEventContext eventContext;
    protected long routeErrorCount = 0L;
    protected byte[] routeErrorCountLock = new byte[0];
    protected IProcessExceptionHandler processExceptionHandler;
    protected Semaphore stopSemaphore = null;

    public RestlessThread(Queue<Task> queue, BlockingQueuePool<Task> queuePool) {
        this.myQueue = queue;
        this.queuePool = queuePool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Queue<Task> myQueue = this.myQueue;
        while (this.isActive) {
            Task runner = null;
            try {
                int otherQueue2;
                runner = myQueue.poll();
                if (runner == null && (otherQueue2 = this.queuePool.currentLongestQueue()) > -1) {
                    runner = this.queuePool.getQueue(otherQueue2).poll();
                }
                if (runner == null) {
                    Queue<Task> otherQueue2 = myQueue;
                    synchronized (otherQueue2) {
                        this.status = 0;
                        myQueue.wait(5000L);
                    }
                }
                if (runner == null) {
                    runner = myQueue.poll();
                }
            }
            catch (InterruptedException e) {
                runner = null;
                this.isActive = false;
            }
            if (runner != null) {
                ++this.processCount;
                this.status = 1;
                this.processingName = runner.getTaskName();
                try {
                    runner.run();
                    continue;
                }
                catch (Throwable e) {
                    ++this.procErrorCount;
                    if (this.processExceptionHandler != null) {
                        this.processExceptionHandler.processException(this, runner, e);
                        continue;
                    }
                    e.printStackTrace();
                    continue;
                }
                finally {
                    this.status = 0;
                    this.processingName = null;
                    this.eventContext = null;
                    continue;
                }
            }
            if (!this.canStop) continue;
            this.isActive = false;
        }
        Semaphore stopSemaphore = this.stopSemaphore;
        if (stopSemaphore != null) {
            stopSemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyToStop(Semaphore stopSemaphore) {
        this.stopSemaphore = stopSemaphore;
        this.canStop = true;
        Queue<Task> myQueue = this.myQueue;
        if (myQueue != null) {
            Queue<Task> queue = myQueue;
            synchronized (queue) {
                myQueue.notifyAll();
            }
        }
    }

    public void shutdown() {
        if (super.isAlive()) {
            this.canStop = true;
            this.isActive = false;
            try {
                Queue<Task> queue = this.myQueue;
                if (queue != null) {
                    this.stop(new Exception("normally exit with [" + queue.size() + "] tasks left"));
                } else {
                    this.stop(new Exception("normally exit"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Queue<Task> getQueue() {
        return this.myQueue;
    }

    public int getStatus() {
        if (super.isAlive()) {
            return this.status;
        }
        return 2;
    }

    public String getCurrentStep() {
        if (this.eventContext != null && this.status == 1) {
            return this.eventContext.getCurrentStep();
        }
        return "none";
    }

    public String getProcessingName() {
        return this.processingName;
    }

    public long getProcessCount() {
        return this.processCount;
    }

    public long getProcErrorCount() {
        return this.procErrorCount;
    }

    public String getThreadName() {
        return super.getName();
    }

    public void setThreadName(String threadName) {
        super.setName(threadName);
    }

    public IEventContext getEventContext() {
        return this.eventContext;
    }

    public void setEventContext(IEventContext eventContext) {
        this.eventContext = eventContext;
    }

    public long getRouteErrorCount() {
        return this.routeErrorCount;
    }

    public IProcessExceptionHandler getProcessExceptionHandler() {
        return this.processExceptionHandler;
    }

    public void setProcessExceptionHandler(IProcessExceptionHandler processExceptionHandler) {
        this.processExceptionHandler = processExceptionHandler;
    }

    public void increaseRouteErrorCount() {
        ++this.routeErrorCount;
    }
}

