/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.core.pool;

import com.hundsun.t2sdk.common.core.pool.BlockingQueuePool;
import com.hundsun.t2sdk.common.core.pool.IProcessExceptionHandler;
import com.hundsun.t2sdk.common.core.pool.ProcessExceptionHandler;
import com.hundsun.t2sdk.common.core.pool.RestlessThread;
import com.hundsun.t2sdk.common.core.pool.Task;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestlessThreadExcutor {
    public static final int STATE_IDLE = 0;
    public static final int STATE_STARTING = 1;
    public static final int STATE_STARTED = 2;
    public static final int STATE_STOPING = 3;
    public static final int STATE_STOPPED = 4;
    protected BlockingQueuePool<Task> queuePool;
    protected ArrayList<RestlessThread> threads;
    protected int threadCount;
    protected String poolName;
    protected int queueSize;
    protected Semaphore stopSemaphore;
    protected volatile int state = 0;
    protected IProcessExceptionHandler processExceptionHandler;

    public RestlessThreadExcutor(int threadCount, int queueSize, String poolName) {
        this(threadCount, queueSize, poolName, new ProcessExceptionHandler());
    }

    public RestlessThreadExcutor(int threadCount, int queueSize, String poolName, IProcessExceptionHandler processExceptionHandler) {
        if (processExceptionHandler == null) {
            processExceptionHandler = new ProcessExceptionHandler();
        }
        this.threadCount = threadCount;
        this.poolName = poolName;
        this.queueSize = queueSize;
        this.processExceptionHandler = processExceptionHandler;
        this.queuePool = new BlockingQueuePool();
        this.threads = new ArrayList(threadCount);
    }

    public synchronized void start() {
        if (this.state == 2) {
            return;
        }
        this.state = 1;
        this.threads.clear();
        this.queuePool.start();
        for (int i = 0; i < this.threadCount; ++i) {
            RestlessThread thread = new RestlessThread(this.queuePool.newQueue(this.queueSize), this.queuePool);
            thread.setThreadName(this.poolName + "#" + i);
            thread.setProcessExceptionHandler(this.processExceptionHandler);
            thread.setUncaughtExceptionHandler(new ThreadExceptionHandler(i));
            this.threads.add(thread);
        }
        for (RestlessThread thread : this.threads) {
            thread.start();
        }
        this.stopSemaphore = new Semaphore(-1 * this.threadCount + 1);
        this.state = 2;
    }

    public synchronized void stop(long timeout) {
        if (this.state == 4) {
            return;
        }
        this.state = 3;
        this.queuePool.notifyToStop();
        for (RestlessThread thread : this.threads) {
            thread.notifyToStop(this.stopSemaphore);
        }
        if (timeout > 0L) {
            try {
                if (this.stopSemaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
                    this.state = 4;
                }
                for (RestlessThread thread : this.threads) {
                    if (thread.getState() == Thread.State.TERMINATED) continue;
                    thread.shutdown();
                }
            }
            catch (InterruptedException e) {}
        } else {
            try {
                this.stopSemaphore.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.threads.clear();
        this.stopSemaphore = null;
        this.state = 4;
    }

    public boolean execute(Task runner) {
        if (this.state != 2) {
            return false;
        }
        return this.queuePool.saveToQueue(runner);
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public List<RestlessThread> getThreads() {
        return this.threads;
    }

    public BlockingQueuePool<Task> getQueuePool() {
        return this.queuePool;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public int getState() {
        return this.state;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public IProcessExceptionHandler getProcessExceptionHandler() {
        return this.processExceptionHandler;
    }

    public void setProcessExceptionHandler(IProcessExceptionHandler processExceptionHandler) {
        this.processExceptionHandler = processExceptionHandler;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    protected class ThreadExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private int threadNo;

        public ThreadExceptionHandler(int threadNo) {
            this.threadNo = threadNo;
        }

        public void uncaughtException(Thread t, Throwable e) {
            if (RestlessThreadExcutor.this.getState() == 2) {
                RestlessThread rt = (RestlessThread)t;
                String threadName = t.getName() + "$new";
                RestlessThread thread = new RestlessThread(rt.getQueue(), RestlessThreadExcutor.this.queuePool);
                thread.setThreadName(threadName);
                thread.setProcessExceptionHandler(RestlessThreadExcutor.this.processExceptionHandler);
                thread.setUncaughtExceptionHandler(new ThreadExceptionHandler(this.threadNo));
                thread.start();
                RestlessThreadExcutor.this.threads.set(this.threadNo, thread);
            }
        }
    }
}

