/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.core.pool;

import com.hundsun.t2sdk.common.core.pool.IProcessExceptionHandler;
import com.hundsun.t2sdk.common.core.pool.Queue;
import com.hundsun.t2sdk.common.core.pool.RestlessThread;
import com.hundsun.t2sdk.common.core.pool.RestlessThreadEx;
import com.hundsun.t2sdk.common.core.pool.RestlessThreadExcutor;
import com.hundsun.t2sdk.common.core.pool.Task;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

public class RestlessThreadExcutorEx
extends RestlessThreadExcutor {
    private byte[] lock = new byte[0];

    public RestlessThreadExcutorEx(int threadCount, int queueSize, String poolName) {
        super(threadCount, queueSize, poolName);
    }

    public RestlessThreadExcutorEx(int threadCount, int queueSize, String poolName, IProcessExceptionHandler processExceptionHandler) {
        super(threadCount, queueSize, poolName, processExceptionHandler);
    }

    public synchronized void start() {
        if (this.queueSize == 0) {
            int queueSize = 1;
            for (int i = 0; i < this.threadCount; ++i) {
                RestlessThread thread = new RestlessThreadEx(this.queuePool.newQueue(queueSize), this.queuePool);
                thread.setThreadName(this.poolName + "#" + i);
                thread.setProcessExceptionHandler(this.processExceptionHandler);
                thread.setUncaughtExceptionHandler(new RestlessThreadExcutor.ThreadExceptionHandler(this, i));
                this.threads.add(thread);
            }
            this.state = 1;
            for (RestlessThread thread : this.threads) {
                thread.start();
            }
            this.stopSemaphore = new Semaphore(-1 * this.threadCount + 1);
            this.state = 2;
        } else {
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Task runner) {
        if (this.state != 2) {
            return false;
        }
        if (this.queueSize == 0) {
            ArrayList threads = this.threads;
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                for (RestlessThread thread : threads) {
                    Queue<Task> queue = thread.getQueue();
                    if (queue.size() != 0 || thread.status != 0) continue;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return queue.offer(runner);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
        }
        return super.execute(runner);
    }
}

