/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.core.queue;

import com.hundsun.t2sdk.common.core.pool.Queue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomQueue<E>
implements Queue<E> {
    private final E[] items;
    private transient int takeIndex;
    private transient int putIndex;
    private int count;
    private final byte[] lock = new byte[0];
    private int capacity;

    final int inc(int i) {
        return ++i == this.items.length ? 0 : i;
    }

    private void insert(E x) {
        this.items[this.putIndex] = x;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
    }

    private E extract() {
        E[] items = this.items;
        E x = items[this.takeIndex];
        items[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        return x;
    }

    public AtomQueue(int capacity) {
        this(capacity, false);
    }

    public AtomQueue(int capacity, boolean fair) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity should be equal to or greater than 0");
        }
        this.items = new Object[capacity];
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E o) {
        if (o == null) {
            throw new NullPointerException();
        }
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (this.count == this.items.length) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            this.insert(o);
            AtomQueue atomQueue = this;
            synchronized (atomQueue) {
                this.notifyAll();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        byte[] lock;
        byte[] byArray = lock = this.lock;
        synchronized (lock) {
            if (this.count == 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            E x = this.extract();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return x;
        }
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.poll();
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }
}

