/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.encrypt;

import com.hundsun.t2sdk.interfaces.encrypt.Encrypt;
import com.hundsun.t2sdk.interfaces.exception.T2SDKBaseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;

public class DesEncrypt
implements Encrypt {
    private static final String ALGORITHM = "DES";
    private static final String DES_KEY_PATH = "deskey";
    private static final String ENCRYPT_SYMBOL_BEGIN = "{";
    private static final String ENCRYPT_SYMBOL_END = "}";
    private static SecretKey deskey;

    public DesEncrypt() {
        this.readKey(DES_KEY_PATH);
    }

    public void createKey(String path) {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(ALGORITHM);
            SecretKey newKey = keygen.generateKey();
            this.saveKey(newKey, path);
        }
        catch (Exception e) {
            new T2SDKBaseException("620", (Throwable)e, new Object[0]).printStackTrace();
        }
    }

    public String getEncryptStr(String strMing) {
        String strMi = "";
        try {
            Cipher c1 = Cipher.getInstance(ALGORITHM);
            c1.init(1, deskey);
            byte[] cipherByte = c1.doFinal(strMing.getBytes());
            strMi = Base64.encodeBase64String((byte[])cipherByte);
        }
        catch (Exception e) {
            new T2SDKBaseException("621", (Throwable)e, new Object[0]).printStackTrace();
        }
        return strMi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDecryptStr(String strMi) {
        String strMing = "";
        byte[] byteMi = null;
        try {
            byteMi = Base64.decodeBase64((String)strMi);
            Cipher c1 = Cipher.getInstance(ALGORITHM);
            c1.init(2, deskey);
            byte[] clearByte = c1.doFinal(byteMi);
            strMing = new String(clearByte);
        }
        catch (Exception e) {
            new T2SDKBaseException("622", (Throwable)e, new Object[0]).printStackTrace();
        }
        finally {
            byteMi = null;
        }
        return strMing;
    }

    public static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
            if (n >= b.length - 1) continue;
            hs = hs + ":";
        }
        return hs.toUpperCase();
    }

    private void saveKey(SecretKey newKey, String keyPath) {
        if (newKey != null) {
            try {
                FileOutputStream fos = new FileOutputStream(keyPath);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(newKey);
            }
            catch (IOException e) {
                new T2SDKBaseException("623", (Throwable)e, new Object[0]).printStackTrace();
            }
        } else {
            new T2SDKBaseException("624", (Throwable)new Exception(), new Object[0]).printStackTrace();
        }
    }

    public void readKey(String filePath) {
        if (deskey == null) {
            try {
                URL url = DesEncrypt.class.getClassLoader().getResource(filePath);
                URLConnection uc = url.openConnection();
                InputStream is = uc.getInputStream();
                ObjectInputStream ois = new ObjectInputStream(is);
                deskey = (SecretKey)ois.readObject();
                ois.close();
                is.close();
            }
            catch (FileNotFoundException e) {
                new T2SDKBaseException("625", (Throwable)e, new Object[0]).printStackTrace();
            }
            catch (IOException e) {
                new T2SDKBaseException("626", (Throwable)e, new Object[0]).printStackTrace();
            }
            catch (Exception e) {
                new T2SDKBaseException("627", (Throwable)e, new Object[0]).printStackTrace();
            }
        }
    }

    public void getDecodeFile(String encodeFileName, String decodeFileName, char beginChacter, char endChacter) {
        StringBuffer enCode = new StringBuffer("");
        enCode = this.getFileContent(encodeFileName);
        String deCode = this.getDeCode(enCode, beginChacter, endChacter);
        this.setFileContent(deCode, decodeFileName);
    }

    private StringBuffer getFileContent(String fileName) {
        StringBuffer _str = new StringBuffer("");
        try {
            String str;
            FileReader fr = new FileReader(fileName);
            BufferedReader br = new BufferedReader(fr);
            while ((str = br.readLine()) != null) {
                _str.append(str);
                _str.append('\r');
            }
            fr.close();
            br.close();
        }
        catch (IOException e) {
            new T2SDKBaseException("623", (Throwable)e, new Object[0]).printStackTrace();
        }
        return _str;
    }

    private void setFileContent(String fileContent, String fileName) {
        try {
            File file = new File(fileName);
            FileWriter filewriter = new FileWriter(file, true);
            filewriter.write(fileContent);
            filewriter.close();
        }
        catch (IOException e) {
            new T2SDKBaseException("628", (Throwable)e, new Object[0]).printStackTrace();
        }
    }

    private String getDeCode(StringBuffer encode, char beginChacter, char endChacter) {
        char[] str = encode.toString().toCharArray();
        StringBuffer temp = new StringBuffer("");
        StringBuffer _temp = new StringBuffer("");
        boolean isbeginOrend = false;
        for (int i = 0; i < str.length; ++i) {
            if (str[i] == endChacter) {
                isbeginOrend = false;
                temp.append(this.getDecryptStr(_temp.toString()));
                _temp = new StringBuffer("");
            }
            if (isbeginOrend) {
                _temp.append(str[i]);
            } else if (str[i] != beginChacter && str[i] != endChacter) {
                temp.append(str[i]);
            }
            if (str[i] != beginChacter) continue;
            isbeginOrend = true;
        }
        return temp.toString();
    }
}

