/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.dataset;

import com.hundsun.t2sdk.common.share.dataset.CommonMetadata;
import com.hundsun.t2sdk.common.share.event.field.Field;
import com.hundsun.t2sdk.common.share.event.field.FieldCreator;
import com.hundsun.t2sdk.common.share.event.field.FieldValue;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasetAttribute;
import com.hundsun.t2sdk.interfaces.share.exception.DatasetRuntimeException;
import com.hundsun.t2sdk.interfaces.share.exception.EventRuntimeException;
import java.util.ArrayList;
import java.util.List;

public class CommonDataset
implements IDataset {
    protected CommonMetadata metadata = new CommonMetadata();
    protected List<List<FieldValue>> lines = new ArrayList<List<FieldValue>>();
    protected int currentLineIndex = 1;
    protected List<FieldValue> currentLine;
    protected String datasetName;
    protected IDatasetAttribute dssa;
    protected int totalCount = -1;
    protected final FieldCreator fc;
    protected int workMode = 1;
    private FieldValue defaultFieldValue;

    protected CommonDataset(IDatasetAttribute dssa) {
        this.dssa = dssa;
        this.fc = FieldCreator.getNewInstance(dssa);
        this.defaultFieldValue = this.fc.getFieldValue((Object)null);
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public byte[] getByteArray(String columnName) {
        return this.getByteArray(columnName, this.dssa.getDefBytes());
    }

    public double getDouble(String columnName) {
        return this.getDouble(columnName, this.dssa.getDefDouble());
    }

    public int getInt(String columnName) {
        return this.getInt(columnName, this.dssa.getDefInt());
    }

    public long getLong(String columnName) {
        return this.getLong(columnName, this.dssa.getDefLong());
    }

    public String getString(String columnName) {
        return this.getString(columnName, this.dssa.getDefString());
    }

    public String[] getStringArray(String columnName) {
        return this.getStringArray(columnName, this.dssa.getDefStrings());
    }

    public byte[] getByteArray(int columnIndex) {
        return this.getByteArray(columnIndex, this.dssa.getDefBytes());
    }

    public double getDouble(int columnIndex) {
        return this.getDouble(columnIndex, this.dssa.getDefDouble());
    }

    public int getInt(int columnIndex) {
        return this.getInt(columnIndex, this.dssa.getDefInt());
    }

    public long getLong(int columnIndex) {
        return this.getLong(columnIndex, this.dssa.getDefLong());
    }

    public String getString(int columnIndex) {
        return this.getString(columnIndex, this.dssa.getDefString());
    }

    public String[] getStringArray(int columnIndex) {
        return this.getStringArray(columnIndex, this.dssa.getDefStrings());
    }

    public int getRowCount() {
        return this.lines.size();
    }

    public void beforeFirst() {
        this.currentLineIndex = 0;
        this.currentLine = null;
    }

    public boolean hasNext() {
        return this.currentLineIndex < this.lines.size();
    }

    public void next() {
        ++this.currentLineIndex;
        this.currentLine = this.lines.get(this.currentLineIndex - 1);
    }

    public int findColumn(String columnName) {
        return this.metadata.findColumn(columnName);
    }

    public int getColumnCount() {
        return this.metadata.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.metadata.getColumnName(column);
    }

    public char getColumnType(int column) {
        return this.metadata.getColumnType(column);
    }

    public boolean appendRow() {
        boolean result = false;
        int size = this.metadata.getColumnCount();
        this.currentLine = new ArrayList<FieldValue>(size);
        this.lines.add(this.currentLine);
        for (int i = 1; i <= size; ++i) {
            this.currentLine.add(this.defaultFieldValue);
        }
        return result;
    }

    public void modifyColumnType(String colName, int type) {
        Integer t = FieldCreator.getTypeMap().get(type);
        if (t == null) {
            throw new EventRuntimeException("69", type);
        }
        int index = this.checkColumnName(colName, true);
        Field field = this.metadata.getField(index);
        field.setType((char)t.intValue());
    }

    public void modifyColumnType(int colIndex, int type) {
        Integer t = FieldCreator.getTypeMap().get(type);
        if (t == null) {
            throw new EventRuntimeException("69", type);
        }
        this.checkColumnIndex(colIndex);
        Field field = this.metadata.getField(colIndex);
        field.setType((char)t.intValue());
    }

    public void updateByteArray(int columnIndex, byte[] v) throws DatasetRuntimeException {
        this.checkColumnIndex(columnIndex);
        this._updateByteArray(columnIndex, v);
    }

    private void _updateByteArray(int columnIndex, byte[] v) throws DatasetRuntimeException {
        FieldValue value = this.fc.getFieldValue(v);
        this.currentLine.set(columnIndex - 1, value);
    }

    public void updateByteArray(String columnName, byte[] v) throws DatasetRuntimeException {
        int columnIndex = this.checkColumnName(columnName, true);
        this._updateByteArray(columnIndex, v);
    }

    public void updateDouble(int columnIndex, double v) throws DatasetRuntimeException {
        this.checkColumnIndex(columnIndex);
        this._updateDouble(columnIndex, v);
    }

    private void _updateDouble(int columnIndex, double v) throws DatasetRuntimeException {
        FieldValue value = this.fc.getFieldValue(v);
        this.currentLine.set(columnIndex - 1, value);
    }

    public void updateDouble(String columnName, double v) throws DatasetRuntimeException {
        int columnIndex = this.checkColumnName(columnName, true);
        this._updateDouble(columnIndex, v);
    }

    public void updateInt(int columnIndex, int v) throws DatasetRuntimeException {
        this.checkColumnIndex(columnIndex);
        this._updateInt(columnIndex, v);
    }

    private void _updateInt(int columnIndex, int v) throws DatasetRuntimeException {
        FieldValue value = this.fc.getFieldValue(v);
        this.currentLine.set(columnIndex - 1, value);
    }

    public void updateInt(String columnName, int v) throws DatasetRuntimeException {
        int columnIndex = this.checkColumnName(columnName, true);
        this._updateInt(columnIndex, v);
    }

    public void updateLong(int columnIndex, long v) throws DatasetRuntimeException {
        this.checkColumnIndex(columnIndex);
        this._updateLong(columnIndex, v);
    }

    private void _updateLong(int columnIndex, long v) throws DatasetRuntimeException {
        FieldValue value = this.fc.getFieldValue(v);
        this.currentLine.set(columnIndex - 1, value);
    }

    public void updateLong(String columnName, long v) throws DatasetRuntimeException {
        int columnIndex = this.checkColumnName(columnName, true);
        this._updateLong(columnIndex, v);
    }

    public void updateString(int columnIndex, String v) throws DatasetRuntimeException {
        this.checkColumnIndex(columnIndex);
        this._updateString(columnIndex, v);
    }

    private void _updateString(int columnIndex, String v) throws DatasetRuntimeException {
        FieldValue value = this.fc.getFieldValue(v);
        this.currentLine.set(columnIndex - 1, value);
    }

    public void updateString(String columnName, String v) throws DatasetRuntimeException {
        int columnIndex = this.checkColumnName(columnName, true);
        this._updateString(columnIndex, v);
    }

    public void updateStringArray(int columnIndex, String[] v) throws DatasetRuntimeException {
        this.checkColumnIndex(columnIndex);
        this._updateStringArray(columnIndex, v);
    }

    private void _updateStringArray(int columnIndex, String[] v) throws DatasetRuntimeException {
        FieldValue value = this.fc.getFieldValue(v);
        this.currentLine.set(columnIndex - 1, value);
    }

    public void updateStringArray(String columnName, String[] v) throws DatasetRuntimeException {
        int columnIndex = this.checkColumnName(columnName, true);
        this._updateStringArray(columnIndex, v);
    }

    public void updateValue(int columnIndex, Object v) {
        this.checkColumnIndex(columnIndex);
        this._updateValue(columnIndex, v);
    }

    private void _updateValue(int columnIndex, Object v) {
        FieldValue value = this.fc.getFieldValue(v);
        this.currentLine.set(columnIndex - 1, value);
    }

    public void updateValue(String columnName, Object v) {
        int columnIndex = this.checkColumnName(columnName, true);
        this._updateValue(columnIndex, v);
    }

    public byte[] getByteArray(String columnName, byte[] def) {
        int index = this.checkColumnName(columnName, this.isExceptionMode());
        if (index == 0) {
            return def;
        }
        return this._getByteArray(index, def);
    }

    public byte[] getByteArray(int columnIndex, byte[] def) {
        this.checkColumnIndex(columnIndex);
        return this._getByteArray(columnIndex, def);
    }

    private byte[] _getByteArray(int columnIndex, byte[] def) {
        FieldValue value = this.currentLine.get(columnIndex - 1);
        try {
            return value.getByteArray(def);
        }
        catch (DatasetRuntimeException e) {
            if (this.isExceptionMode()) {
                throw e;
            }
            return def;
        }
    }

    public double getDouble(String columnName, double def) {
        int index = this.checkColumnName(columnName, this.isExceptionMode());
        if (index == 0) {
            return def;
        }
        return this._getDouble(index, def);
    }

    public double getDouble(int columnIndex, double def) {
        this.checkColumnIndex(columnIndex);
        return this._getDouble(columnIndex, def);
    }

    private double _getDouble(int columnIndex, double def) {
        FieldValue value = this.currentLine.get(columnIndex - 1);
        try {
            return value.getDouble(def);
        }
        catch (DatasetRuntimeException e) {
            if (this.isExceptionMode()) {
                throw e;
            }
            return def;
        }
    }

    public int getInt(String columnName, int def) {
        int index = this.checkColumnName(columnName, this.isExceptionMode());
        if (index == 0) {
            return def;
        }
        return this._getInt(index, def);
    }

    public int getInt(int columnIndex, int def) {
        this.checkColumnIndex(columnIndex);
        return this._getInt(columnIndex, def);
    }

    private int _getInt(int columnIndex, int def) {
        FieldValue value = this.currentLine.get(columnIndex - 1);
        try {
            return value.getInt(def);
        }
        catch (DatasetRuntimeException e) {
            if (this.isExceptionMode()) {
                throw e;
            }
            return def;
        }
    }

    public long getLong(String columnName, long def) {
        int index = this.checkColumnName(columnName, this.isExceptionMode());
        if (index == 0) {
            return def;
        }
        return this._getLong(index, def);
    }

    public long getLong(int columnIndex, long def) {
        this.checkColumnIndex(columnIndex);
        return this._getLong(columnIndex, def);
    }

    private long _getLong(int columnIndex, long def) {
        FieldValue value = this.currentLine.get(columnIndex - 1);
        try {
            return value.getLong(def);
        }
        catch (DatasetRuntimeException e) {
            if (this.isExceptionMode()) {
                throw e;
            }
            return def;
        }
    }

    public String getString(String columnName, String def) {
        int index = this.checkColumnName(columnName, this.isExceptionMode());
        if (index == 0) {
            return def;
        }
        return this._getString(index, def);
    }

    public String getString(int columnIndex, String def) {
        this.checkColumnIndex(columnIndex);
        return this._getString(columnIndex, def);
    }

    private String _getString(int columnIndex, String def) {
        FieldValue value = this.currentLine.get(columnIndex - 1);
        try {
            return value.getString(def);
        }
        catch (DatasetRuntimeException e) {
            if (this.isExceptionMode()) {
                throw e;
            }
            return def;
        }
    }

    public String[] getStringArray(String columnName, String[] def) {
        int index = this.checkColumnName(columnName, this.isExceptionMode());
        if (index == 0) {
            return def;
        }
        return this._getStringArray(index, def);
    }

    public String[] getStringArray(int columnIndex, String[] def) {
        this.checkColumnIndex(columnIndex);
        return this._getStringArray(columnIndex, def);
    }

    private String[] _getStringArray(int columnIndex, String[] def) {
        FieldValue value = this.currentLine.get(columnIndex - 1);
        try {
            return value.getStringArray(def);
        }
        catch (DatasetRuntimeException e) {
            if (this.isExceptionMode()) {
                throw e;
            }
            return def;
        }
    }

    public Object getValue(String columnName) {
        return this.getValue(columnName, null);
    }

    public Object getValue(int columnIndex) {
        return this.getValue(columnIndex, null);
    }

    public Object getValue(String columnName, Object def) {
        int index = this.checkColumnName(columnName, this.isExceptionMode());
        if (index == 0) {
            return this.dssa.getDefLong();
        }
        return this._getValue(index, def);
    }

    public Object getValue(int columnIndex, Object def) {
        this.checkColumnIndex(columnIndex);
        return this._getValue(columnIndex, def);
    }

    private Object _getValue(int columnIndex, Object def) {
        FieldValue value = this.currentLine.get(columnIndex - 1);
        try {
            return value.getValue();
        }
        catch (DatasetRuntimeException e) {
            if (this.isExceptionMode()) {
                throw e;
            }
            return def;
        }
    }

    public void addColumn(String colName, int type) {
        List<FieldValue> vs;
        Field field = this.fc.getField(colName, type);
        int realIndex = this.metadata.addField(field);
        int size = this.lines.size();
        if (size > 0 && realIndex > (vs = this.lines.get(0)).size()) {
            for (int i = 0; i < size; ++i) {
                vs = this.lines.get(i);
                FieldValue fv = this.fc.getDefaultValue(field.getType());
                vs.add(fv);
            }
        }
    }

    public void addColumn(String colName) {
        this.addColumn(colName, 83);
    }

    public int getMode() {
        return this.workMode;
    }

    public void setMode(int mode) {
        this.workMode = 0 == mode ? mode : 1;
    }

    public void setDatasetName(String name) {
        this.datasetName = name;
    }

    public IDatasetAttribute getDatasetAttribute() {
        return this.dssa;
    }

    public IDatasetAttribute setDatasetAttribute(IDatasetAttribute dssa) {
        if (dssa == null) {
            return null;
        }
        IDatasetAttribute pre = dssa;
        this.dssa.copyFrom(dssa);
        return pre;
    }

    public void clear() {
        this.lines.clear();
        this.currentLineIndex = 1;
        this.currentLine = null;
    }

    public void clearAll() {
        this.metadata.clear();
        this.lines.clear();
        this.currentLineIndex = 1;
        this.currentLine = null;
    }

    public void locateLine(int lineIndex) {
        if (!this.locateRow(lineIndex)) {
            throw new DatasetRuntimeException("65", lineIndex, 1, this.lines.size());
        }
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    protected boolean isExceptionMode() {
        return 0 == this.getMode();
    }

    protected boolean locateRow(int rowIndex) {
        if (rowIndex >= 1 && rowIndex <= this.getRowCount()) {
            this.currentLineIndex = rowIndex;
            this.currentLine = this.lines.get(this.currentLineIndex - 1);
            return true;
        }
        return false;
    }

    protected int checkColumnName(String columnName, boolean bException) {
        int index = this.metadata.findColumn(columnName);
        if (index == 0 && bException) {
            throw new DatasetRuntimeException("68", new Object[]{columnName});
        }
        return index;
    }

    protected void checkColumnIndex(int columnIndex) {
        if (!this.metadata.isValidColumnIndex(columnIndex)) {
            throw new DatasetRuntimeException("66", columnIndex, 1, this.metadata.getColumnCount());
        }
    }

    public int getCurrentLineIndex() {
        return this.currentLineIndex;
    }
}

