/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.dataset;

import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasets;
import com.hundsun.t2sdk.interfaces.share.exception.DatasetRuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonDatasets
implements IDatasets {
    private Map<String, IDataset> nameMapResult = new HashMap<String, IDataset>();
    private List<String> names = new ArrayList<String>();

    public IDataset getDataset(String name) {
        return this.nameMapResult.get(name);
    }

    public IDataset getDataset(int index) {
        if (index >= 0 && index < this.names.size()) {
            String name = this.names.get(index);
            return this.nameMapResult.get(name);
        }
        return null;
    }

    public int getDatasetCount() {
        return this.names.size();
    }

    public String getDatasetName(int index) {
        if (index >= 0 && index < this.names.size()) {
            return this.names.get(index);
        }
        return null;
    }

    public void putDataset(IDataset dataset) {
        if (dataset == null) {
            throw new DatasetRuntimeException("2", new Object[]{"input dataset is null"});
        }
        String name = dataset.getDatasetName();
        if (name == null) {
            String firstName;
            if (this.getDatasetCount() > 0 && (firstName = this.getDataset(0).getDatasetName()) == null) {
                throw new DatasetRuntimeException("8", new Object[]{"duplicate default dataset"});
            }
            this.names.add(0, null);
            this.nameMapResult.put(null, dataset);
        } else {
            int index = this.names.indexOf(name);
            if (index == -1) {
                this.names.add(name);
            }
            dataset.setDatasetName(name);
            this.nameMapResult.put(name, dataset);
        }
    }

    public void clear() {
        this.nameMapResult.clear();
        this.names.clear();
    }
}

