/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.dataset;

import com.hundsun.t2sdk.common.share.event.field.Field;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CommonMetadata
implements IDatasetMetaData,
Cloneable {
    protected ArrayList<Field> fields = new ArrayList();
    protected Map<String, Integer> mapping = new HashMap<String, Integer>();

    public int addField(Field field) {
        this.fields.add(field);
        int index = this.findColumn(field.getName());
        if (index == 0) {
            this.mapping.put(field.getName(), this.fields.size() - 1);
        }
        return this.fields.size();
    }

    public int findColumn(String columnName) {
        int index = 0;
        if (columnName == null || columnName.length() == 0) {
            return index;
        }
        Integer it = this.mapping.get(columnName);
        index = it == null ? 0 : it + 1;
        return index;
    }

    public int getColumnCount() {
        return this.fields.size();
    }

    public String getColumnName(int column) {
        if (!this.isValidColumnIndex(column)) {
            return null;
        }
        return this.fields.get(column - 1).getName();
    }

    public char getColumnType(int column) {
        if (!this.isValidColumnIndex(column)) {
            return 'N';
        }
        return this.fields.get(column - 1).getType();
    }

    public boolean isValidColumnIndex(int column) {
        return column > 0 && column <= this.fields.size();
    }

    public Field getField(int column) {
        if (this.isValidColumnIndex(column)) {
            return this.fields.get(column - 1);
        }
        return null;
    }

    protected void clear() {
        this.fields.clear();
        this.mapping.clear();
    }

    public CommonMetadata clone() {
        CommonMetadata other;
        try {
            other = (CommonMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        other.mapping = new HashMap<String, Integer>(this.mapping.size());
        other.mapping.putAll(this.mapping);
        int size = this.fields.size();
        ArrayList<Field> newFields = other.fields = new ArrayList(size);
        ArrayList<Field> oldFields = this.fields;
        for (int i = 0; i < size; ++i) {
            newFields.add(oldFields.get(i).clone());
        }
        return other;
    }

    public String toString() {
        ArrayList<Field> oldFields = this.fields;
        int size = oldFields.size();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < size; ++i) {
            sb.append(oldFields.get(i).toString());
            if (i == size - 1) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

