/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.dataset;

import com.hundsun.t2sdk.common.share.caseStrategy.BaseCaseStrategy;
import com.hundsun.t2sdk.common.share.caseStrategy.BeanUtil;
import com.hundsun.t2sdk.common.share.caseStrategy.CamelCaseStrategy;
import com.hundsun.t2sdk.common.share.caseStrategy.NormalCaseStrategy;
import com.hundsun.t2sdk.common.share.dataset.CommonDataset;
import com.hundsun.t2sdk.common.share.dataset.DatasetAttribute;
import com.hundsun.t2sdk.common.share.dataset.MapWriter;
import com.hundsun.t2sdk.common.share.dataset.convertor.Convertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.ConvertorRegistry;
import com.hundsun.t2sdk.common.share.event.field.FieldCreator;
import com.hundsun.t2sdk.common.share.event.field.FieldValue;
import com.hundsun.t2sdk.common.util.objectutil.PropertyUtils;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasetAttribute;
import com.hundsun.t2sdk.interfaces.share.dataset.writer.IMapWriter;
import com.hundsun.t2sdk.interfaces.share.exception.DatasetException;
import com.hundsun.t2sdk.interfaces.share.exception.DatasetRuntimeException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetService {
    protected static DatasetService staticInstance;
    protected static IDatasetAttribute staticdssa;
    protected IDatasetAttribute dssa;
    protected FieldCreator fc;
    protected ConvertorRegistry convertorRegistry;

    protected DatasetService(IDatasetAttribute dssa) {
        this.dssa = dssa == null ? new DatasetAttribute() : dssa;
        this.fc = FieldCreator.getNewInstance(this.dssa);
        this.convertorRegistry = new ConvertorRegistry();
    }

    public static DatasetService getDefaultInstance() {
        return staticInstance;
    }

    public static DatasetService getInstace() {
        return new DatasetService(new DatasetAttribute());
    }

    public static DatasetService getInstace(IDatasetAttribute attr) {
        return new DatasetService(attr);
    }

    public static IDatasetAttribute getDefaultDatasetAttribute() {
        return staticdssa;
    }

    public static IDatasetAttribute getDatasetAttribute(IDataset dataset) {
        if (dataset == null) {
            return null;
        }
        CommonDataset ds = (CommonDataset)dataset;
        return ds.getDatasetAttribute();
    }

    public static void setDatasetAttribute(IDataset dataset, IDatasetAttribute dssa) {
        if (dataset != null && dssa != null) {
            CommonDataset ds = (CommonDataset)dataset;
            IDatasetAttribute attribute = ds.getDatasetAttribute();
            attribute.copyFrom(dssa);
        }
    }

    public IDataset getDataset() {
        return this.getDataset(staticdssa);
    }

    public IDataset getDataset(IDatasetAttribute attr) {
        return new CommonDataset(attr);
    }

    public IDataset getDataset(HttpServletRequest request) {
        return this.getDataset(request, staticdssa);
    }

    public IDataset getDataset(HttpServletRequest request, IDatasetAttribute attr) {
        Object value;
        String key;
        IDataset ds = this.getDataset(attr);
        int maxStringArray = 0;
        HashMap strings = new HashMap();
        HashMap<String, String[]> stringArrays = new HashMap<String, String[]>();
        Map map = request.getParameterMap();
        for (Map.Entry entry : map.entrySet()) {
            String key2 = (String)entry.getKey();
            Object value2 = entry.getValue();
            if (value2 == null || !(value2 instanceof String[])) continue;
            String[] vs = (String[])value2;
            if (maxStringArray < vs.length) {
                maxStringArray = vs.length;
            }
            stringArrays.put(key2, vs);
            ds.addColumn(key2, 83);
        }
        int stringArraySize = stringArrays.size();
        int stringSize = strings.size();
        if (stringArraySize != 0) {
            for (int i = 0; i < maxStringArray; ++i) {
                ds.appendRow();
            }
            for (Map.Entry entry : stringArrays.entrySet()) {
                key = (String)entry.getKey();
                value = (String[])entry.getValue();
                for (int i = 0; i < ((String[])value).length; ++i) {
                    ds.locateLine(i + 1);
                    ds.updateString(key, value[i]);
                }
            }
        }
        if (stringSize != 0) {
            if (ds.getRowCount() == 0) {
                ds.appendRow();
            }
            for (Map.Entry entry : strings.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                ds.addColumn(key, 83);
                ds.locateLine(1);
                ds.updateString(key, (String)value);
            }
        }
        if (ds.getRowCount() != 0) {
            ds.locateLine(1);
        }
        return ds;
    }

    public IDataset getDataset(ResultSet rs) {
        return this.getDataset(rs, staticdssa);
    }

    public IDataset getDataset(ResultSet rs, IDatasetAttribute attr) {
        IDataset cds = this.getDataset(attr);
        try {
            int i;
            ResultSetMetaData rsmeta = rs.getMetaData();
            int colCount = rsmeta.getColumnCount();
            for (i = 1; i <= colCount; ++i) {
                cds.addColumn(rsmeta.getColumnName(i), rsmeta.getColumnType(i));
            }
            while (rs.next()) {
                cds.appendRow();
                for (i = 1; i <= colCount; ++i) {
                    cds.updateValue(i, rs.getObject(i));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return cds;
    }

    public IDataset getErrorDataset(int returnCode, String errorNo, String errorInfo) {
        IDataset errorDataset = this.getDataset(staticdssa);
        errorDataset.setDatasetName("error");
        errorDataset.addColumn("returnCode", 73);
        errorDataset.addColumn("errorNo", 76);
        errorDataset.addColumn("errorInfo", 83);
        errorDataset.appendRow();
        errorDataset.updateInt("returnCode", returnCode);
        errorDataset.updateString("errorNo", errorNo);
        errorDataset.updateString("errorInfo", errorInfo);
        return errorDataset;
    }

    public IDataset getDataset(Map oneRow) {
        return this.getDataset(oneRow, staticdssa);
    }

    public IDataset getDataset(Map oneRow, IDatasetAttribute attr) {
        if (oneRow == null) {
            return this.getDataset(attr);
        }
        ArrayList<Map> l = new ArrayList<Map>();
        l.add(oneRow);
        return this.getDataset(l, attr);
    }

    public IDataset getDataset(Collection<Map> mutiRows) {
        return this.getDataset(mutiRows, staticdssa);
    }

    public IDataset getDataset(Collection<Map> mutiRows, IDatasetAttribute attr) {
        Object value;
        String key;
        if (mutiRows == null || mutiRows.size() == 0) {
            return this.getDataset();
        }
        Iterator<Map> it = mutiRows.iterator();
        IDataset ds = this.getDataset(attr);
        Map oneRow = it.next();
        if (oneRow.size() == 0) {
            return this.getDataset(attr);
        }
        for (Map.Entry e : oneRow.entrySet()) {
            key = (String)e.getKey();
            value = e.getValue();
            this.addColumnWithValue(ds, key, value);
        }
        it = mutiRows.iterator();
        while (it.hasNext()) {
            ds.appendRow();
            oneRow = it.next();
            for (Map.Entry e : oneRow.entrySet()) {
                key = (String)e.getKey();
                value = e.getValue();
                try {
                    this.updateRowValue(ds, key, value);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        return ds;
    }

    public IDataset getDataset(Object oneRow, Class<?> clz) {
        return this.getDataset(oneRow, clz, staticdssa);
    }

    public IDataset getDataset(Object oneRow, Class<?> clz, IDatasetAttribute attr) {
        if (oneRow == null) {
            Collection<?> l = null;
            return this.getDataset(l, clz, attr);
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(oneRow);
        return this.getDataset(l, clz);
    }

    public IDataset getDataset(Collection<?> mutiRows, Class<?> clz) {
        return this.getDataset(mutiRows, clz, staticdssa);
    }

    public IDataset getDataset(Collection<?> mutiRows, Class<?> clz, IDatasetAttribute attr) {
        if (mutiRows == null || mutiRows.size() == 0) {
            IDataset ds = this.getDataset();
            if (clz != null) {
                List attrs = PropertyUtils.getReadableProperties(clz);
                for (String prop : attrs) {
                    if ("class".equals(prop)) continue;
                    ds.addColumn(prop, 83);
                }
            }
            return ds;
        }
        IDataset ds = this.getDataset(attr);
        Object obj = mutiRows.iterator().next();
        if (obj == null) {
            return this.getDataset(attr);
        }
        List attrs = PropertyUtils.getReadableProperties(obj);
        for (String prop : attrs) {
            if ("class".equals(prop)) continue;
            Object value = PropertyUtils.read(obj, prop);
            this.addColumnWithValue(ds, prop, value);
        }
        for (Object o : mutiRows) {
            if (!clz.isInstance(o)) continue;
            ds.appendRow();
            for (String prop : attrs) {
                if ("class".equals(prop)) continue;
                Object value = PropertyUtils.read(o, prop);
                try {
                    this.updateRowValue(ds, prop, value);
                }
                catch (DatasetException e) {
                    e.printStackTrace();
                }
            }
        }
        return ds;
    }

    public IMapWriter getMapWriter(IDataset ds) {
        if (ds == null) {
            throw new DatasetRuntimeException("2", new Object[]{"can not process dataset[null]"});
        }
        return new MapWriter(ds, DatasetService.getDatasetAttribute(ds));
    }

    private void addColumnWithValue(IDataset ds, String key, Object object) {
        int type = 83;
        if (object != null) {
            FieldValue fv = this.fc.getFieldValue(object);
            type = fv.getType();
        }
        ds.addColumn(key, type);
    }

    private void updateRowValue(IDataset ds, String key, Object object) throws DatasetException {
        ds.updateValue(key, object);
    }

    public IDatasetAttribute getDatasetAttribute() {
        return this.dssa;
    }

    public IDatasetAttribute setDatasetAttribute(IDatasetAttribute dssa) {
        IDatasetAttribute pre = this.dssa;
        this.dssa.copyFrom(dssa);
        this.fc = FieldCreator.getNewInstance(this.dssa);
        return pre;
    }

    public static void printDataset(IDataset ds) {
        int j;
        int currentLineIndex = ((CommonDataset)ds).getCurrentLineIndex();
        StringBuilder sb = new StringBuilder();
        int columnCount = ds.getColumnCount();
        for (j = 1; j <= columnCount; ++j) {
            sb.append("# " + j + "\t");
            sb.append(ds.getColumnName(j));
            sb.append("\t");
            sb.append(ds.getColumnType(j) + "\n");
        }
        ds.beforeFirst();
        while (ds.hasNext()) {
            ds.next();
            for (j = 1; j <= columnCount; ++j) {
                sb.append("|" + ds.getString(ds.getColumnName(j)) + "\t");
            }
            sb.append("\n");
        }
        if (currentLineIndex == 0 || ds.getRowCount() == 0) {
            ds.beforeFirst();
        } else {
            ds.locateLine(currentLineIndex);
        }
        System.out.println(sb.toString());
    }

    public <T> T getObject(IDataset dataset, Class<T> clz) {
        T ret = null;
        dataset.beforeFirst();
        if (dataset.hasNext()) {
            ret = this.getObjectFromDataset(dataset, clz, new NormalCaseStrategy());
        }
        return ret;
    }

    public <T> T getHsStdObject(IDataset dataset, Class<T> clz) {
        T ret = null;
        dataset.beforeFirst();
        if (dataset.hasNext()) {
            ret = this.getObjectFromDataset(dataset, clz, new CamelCaseStrategy());
        }
        return ret;
    }

    private <T> T getObjectFromDataset(IDataset dataset, Class<T> clz, BaseCaseStrategy caseStrategy) {
        T obj = this.getObject(clz);
        if (obj != null) {
            dataset.next();
            for (int i = 1; i <= dataset.getColumnCount(); ++i) {
                try {
                    this.setProperty(obj, caseStrategy.getPropertyName(dataset.getColumnName(i)), dataset, i);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return obj;
    }

    private <T> void setProperty(T obj, String fieldName, IDataset dataset, int index) throws Exception {
        Field field = obj.getClass().getDeclaredField(fieldName);
        Class<?> type = field.getType();
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            BeanUtil.setProperty(obj, fieldName, dataset.getLong(index));
        } else if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            BeanUtil.setProperty(obj, fieldName, dataset.getInt(index));
        } else if (type.equals(String.class)) {
            String value = dataset.getString(index);
            if (value == null) {
                value = "";
            }
            BeanUtil.setProperty(obj, fieldName, value);
        } else if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            BeanUtil.setProperty(obj, fieldName, dataset.getDouble(index));
        } else {
            BeanUtil.setProperty(obj, fieldName, dataset.getString(index));
        }
    }

    private <T> T getObject(Class<T> clz) {
        T obj = null;
        try {
            obj = clz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    public <T> T transform(IDataset dataset, Class<T> clz) {
        if (dataset.getRowCount() <= 0) {
            return null;
        }
        try {
            HashMap convertors = new HashMap();
            HashMap<String, Method> setMethods = new HashMap<String, Method>();
            this.parseClass(clz, this.convertorRegistry, setMethods, convertors);
            dataset.locateLine(1);
            return this.constructClass(dataset, clz, setMethods, convertors);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T transform(IDataset dataset, Class<T> clz, ConvertorRegistry convertorRegistry) {
        if (dataset.getRowCount() <= 0) {
            return null;
        }
        try {
            convertorRegistry = new ConvertorRegistry(convertorRegistry);
            HashMap convertors = new HashMap();
            HashMap<String, Method> setMethods = new HashMap<String, Method>();
            this.parseClass(clz, convertorRegistry, setMethods, convertors);
            dataset.locateLine(1);
            return this.constructClass(dataset, clz, setMethods, convertors);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> List<T> transformToList(IDataset dataset, Class<T> clz) {
        ArrayList<T> list = new ArrayList<T>();
        if (dataset.getRowCount() <= 0) {
            return list;
        }
        try {
            HashMap convertors = new HashMap();
            HashMap<String, Method> setMethods = new HashMap<String, Method>();
            this.parseClass(clz, this.convertorRegistry, setMethods, convertors);
            int datasetCount = dataset.getRowCount();
            for (int i = 1; i <= datasetCount; ++i) {
                dataset.locateLine(i);
                T t = this.constructClass(dataset, clz, setMethods, convertors);
                list.add(t);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return list;
    }

    public <T> List<T> transformToList(IDataset dataset, Class<T> clz, ConvertorRegistry convertorRegistry) {
        ArrayList<T> list = new ArrayList<T>();
        if (dataset.getRowCount() <= 0) {
            return list;
        }
        try {
            convertorRegistry = new ConvertorRegistry(convertorRegistry);
            HashMap convertors = new HashMap();
            HashMap<String, Method> setMethods = new HashMap<String, Method>();
            this.parseClass(clz, convertorRegistry, setMethods, convertors);
            int datasetCount = dataset.getRowCount();
            for (int i = 1; i <= datasetCount; ++i) {
                dataset.locateLine(i);
                T t = this.constructClass(dataset, clz, setMethods, convertors);
                list.add(t);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return list;
    }

    private <T> T constructClass(IDataset dataset, Class<T> clz, Map<String, Method> setMethods, Map<String, Convertor<?>> convertors) throws Exception {
        T t = clz.getConstructor(new Class[0]).newInstance(new Object[0]);
        for (Map.Entry<String, Method> entiry : setMethods.entrySet()) {
            String fieldName = entiry.getKey();
            Method setMethod = entiry.getValue();
            Convertor<?> convertor = convertors.get(fieldName);
            setMethod.invoke(t, convertor.convert(dataset, fieldName));
        }
        return t;
    }

    private <T> void parseClass(Class<T> clz, ConvertorRegistry convertorRegistry, Map<String, Method> setMethods, Map<String, Convertor<?>> convertors) {
        Field[] fields;
        for (Field field : fields = clz.getDeclaredFields()) {
            Class<?> typeClass = field.getType();
            String fieldName = field.getName();
            String stringLetter = fieldName.substring(0, 1).toUpperCase();
            String setName = "set" + stringLetter + fieldName.substring(1);
            try {
                Method setMethod = clz.getMethod(setName, typeClass);
                setMethods.put(fieldName, setMethod);
                convertors.put(fieldName, convertorRegistry.getConvertor(typeClass));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public Map<String, Object> transformToMap(IDataset dataset) {
        if (dataset.getRowCount() <= 0) {
            return new HashMap<String, Object>();
        }
        dataset.locateLine(1);
        return this.parseDatasetToMap(dataset);
    }

    public List<Map<String, Object>> transformToListMap(IDataset dataset) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int rowCount = dataset.getRowCount();
        int colCount = dataset.getColumnCount();
        if (rowCount <= 0 || colCount <= 0) {
            return list;
        }
        for (int i = 1; i <= rowCount; ++i) {
            dataset.locateLine(i);
            list.add(this.parseDatasetToMap(dataset));
        }
        return list;
    }

    private Map<String, Object> parseDatasetToMap(IDataset dataset) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int colCount = dataset.getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            map.put(dataset.getColumnName(i), dataset.getValue(i));
        }
        return map;
    }

    static {
        staticdssa = new DatasetAttribute();
        staticInstance = new DatasetService(staticdssa);
    }
}

