/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.dataset;

import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;

public class DatesetCoalition {
    private static DatesetCoalition dataDatesetCoalition = new DatesetCoalition();

    public static DatesetCoalition getInstance() {
        return dataDatesetCoalition;
    }

    public IDataset append(IDataset src, IDataset des) {
        int desColCount = des.getColumnCount();
        int desRowCount = des.getRowCount();
        for (int i = 1; i <= desColCount; ++i) {
            boolean same = false;
            for (int j = 1; j <= src.getColumnCount(); ++j) {
                if (!src.getColumnName(j).equals(des.getColumnName(i))) continue;
                same = true;
                break;
            }
            if (same) continue;
            src.addColumn(des.getColumnName(i));
        }
        for (int index = 1; index <= desRowCount; ++index) {
            src.appendRow();
            des.locateLine(index);
            for (int colIndex = 1; colIndex <= desColCount; ++colIndex) {
                src.updateValue(des.getColumnName(colIndex), des.getValue(colIndex));
            }
        }
        return src;
    }

    public IDataset join(IDataset src, IDataset des) {
        int srcColCount = src.getColumnCount();
        int desColCount = des.getColumnCount();
        int desRowCount = des.getRowCount();
        int srcRowCount = src.getRowCount();
        boolean same = false;
        for (int i = 1; i <= desColCount; ++i) {
            same = false;
            for (int j = 1; j <= srcColCount; ++j) {
                if (!des.getColumnName(i).equals(src.getColumnName(j))) continue;
                same = true;
                break;
            }
            if (same) continue;
            src.addColumn(des.getColumnName(i));
            int rowCount = desRowCount <= srcRowCount ? desRowCount : srcRowCount;
            for (int index = 1; index <= rowCount; ++index) {
                src.locateLine(index);
                des.locateLine(index);
                src.updateValue(des.getColumnName(i), des.getValue(i));
            }
        }
        return src;
    }
}

