/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.dataset;

import com.hundsun.t2sdk.common.share.dataset.DatasetService;
import com.hundsun.t2sdk.common.share.event.field.FieldCreator;
import com.hundsun.t2sdk.common.share.event.field.FieldValue;
import com.hundsun.t2sdk.common.share.util.IndexMap;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasetAttribute;

public class MapReader {
    private IDataset dataset = null;
    private IndexMap<FieldValue> values = new IndexMap();
    private FieldCreator fc;
    private IDatasetAttribute dsa;

    public MapReader(IDataset ds) {
        this.dataset = ds;
        this.dsa = DatasetService.getDefaultDatasetAttribute();
        this.fc = FieldCreator.getNewInstance(DatasetService.getDefaultDatasetAttribute());
        this.trans2Map();
    }

    protected void trans2Map() {
        if (this.dataset != null && this.dataset.getRowCount() > 0) {
            this.dataset.locateLine(1);
            int colCount = this.dataset.getColumnCount();
            for (int i = 1; i <= colCount; ++i) {
                String colName = this.dataset.getColumnName(i);
                Object value = this.dataset.getValue(i);
                FieldValue fv = this.fc.getFieldValue(value);
                this.values.put(colName, fv);
            }
        }
    }

    public int getInt(String columnName) {
        FieldValue fv = this.values.get(columnName);
        if (fv != null) {
            return fv.getInt();
        }
        return this.dsa.getDefInt();
    }

    public int getInt(String columnName, int def) {
        FieldValue fv = this.values.get(columnName);
        if (fv != null) {
            try {
                return fv.getInt(def);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return def;
    }

    public long getLong(String columnName) {
        FieldValue fv = this.values.get(columnName);
        if (fv != null) {
            return fv.getLong();
        }
        return this.dsa.getDefLong();
    }

    public long getLong(String columnName, long def) {
        FieldValue fv = this.values.get(columnName);
        if (fv != null) {
            try {
                return fv.getLong(def);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return def;
    }

    public double getDouble(String columnName) {
        FieldValue fv = this.values.get(columnName);
        if (fv != null) {
            return fv.getDouble();
        }
        return this.dsa.getDefDouble();
    }

    public double getDouble(String columnName, double def) {
        FieldValue fv = this.values.get(columnName);
        if (fv != null) {
            try {
                return fv.getDouble(def);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return def;
    }

    public byte[] getByteArray(String columnName) {
        FieldValue fv = this.values.get(columnName);
        if (fv != null) {
            return fv.getByteArray();
        }
        return this.dsa.getDefBytes();
    }

    public byte[] getByteArray(String columnName, byte[] def) {
        FieldValue fv = this.values.get(columnName);
        if (fv != null) {
            try {
                return fv.getByteArray(def);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return def;
    }

    public String getString(String columnName) {
        FieldValue fv = this.values.get(columnName);
        if (fv != null) {
            return fv.getString();
        }
        return this.dsa.getDefString();
    }

    public String getString(String columnName, String def) {
        FieldValue fv = this.values.get(columnName);
        if (fv != null) {
            try {
                return fv.getString(def);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return def;
    }

    public String[] getStringArray(String columnName) {
        FieldValue fv = this.values.get(columnName);
        if (fv != null) {
            return fv.getStringArray();
        }
        return this.dsa.getDefStrings();
    }

    public String[] getStringArray(String columnName, String[] def) {
        FieldValue fv = this.values.get(columnName);
        if (fv != null) {
            try {
                return fv.getStringArray(def);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return def;
    }

    public Object getValue(String columnName) {
        FieldValue fv = this.values.get(columnName);
        if (fv != null) {
            return fv.getValue();
        }
        return null;
    }

    public Object getValue(String columnName, Object def) {
        FieldValue fv = this.values.get(columnName);
        if (fv != null) {
            return fv.getValue();
        }
        return def;
    }
}

