/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.dataset;

import com.hundsun.t2sdk.common.share.dataset.DatasetService;
import com.hundsun.t2sdk.common.share.event.field.FieldCreator;
import com.hundsun.t2sdk.common.share.event.field.FieldValue;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasetAttribute;
import com.hundsun.t2sdk.interfaces.share.dataset.writer.IMapWriter;
import com.hundsun.t2sdk.interfaces.share.exception.DatasetRuntimeException;

public class MapWriter
implements IMapWriter {
    private IDataset ds;
    private FieldCreator fc;

    public MapWriter() {
        this(DatasetService.getDefaultInstance().getDataset(), DatasetService.getDefaultDatasetAttribute());
    }

    public MapWriter(IDataset ds) {
        this(ds, DatasetService.getDefaultDatasetAttribute());
    }

    public MapWriter(IDataset ds, IDatasetAttribute dssa) {
        if (ds == null) {
            throw new DatasetRuntimeException("2", new Object[]{"dataset is null"});
        }
        this.ds = ds;
        this.fc = FieldCreator.getNewInstance(dssa);
    }

    public void put(String name, int value) {
        if (this.ds.getRowCount() == 0) {
            this.ds.appendRow();
        }
        this.ds.locateLine(1);
        FieldValue fv = this.fc.getFieldValue(value);
        this.ds.addColumn(name, fv.getType());
        this.ds.updateInt(name, value);
    }

    public void put(String name, long value) {
        if (this.ds.getRowCount() == 0) {
            this.ds.appendRow();
        }
        this.ds.locateLine(1);
        FieldValue fv = this.fc.getFieldValue(value);
        this.ds.addColumn(name, fv.getType());
        this.ds.updateLong(name, value);
    }

    public void put(String name, double value) {
        if (this.ds.getRowCount() == 0) {
            this.ds.appendRow();
        }
        this.ds.locateLine(1);
        FieldValue fv = this.fc.getFieldValue(value);
        this.ds.addColumn(name, fv.getType());
        this.ds.updateDouble(name, value);
    }

    public void put(String name, String value) {
        if (this.ds.getRowCount() == 0) {
            this.ds.appendRow();
        }
        this.ds.locateLine(1);
        FieldValue fv = this.fc.getFieldValue(value);
        this.ds.addColumn(name, fv.getType());
        this.ds.updateString(name, value);
    }

    public void put(String name, byte[] value) {
        if (this.ds.getRowCount() == 0) {
            this.ds.appendRow();
        }
        this.ds.locateLine(1);
        FieldValue fv = this.fc.getFieldValue(value);
        this.ds.addColumn(name, fv.getType());
        this.ds.updateByteArray(name, value);
    }

    public void put(String name, String[] value) {
        if (this.ds.getRowCount() == 0) {
            this.ds.appendRow();
        }
        this.ds.locateLine(1);
        FieldValue fv = this.fc.getFieldValue(value);
        this.ds.addColumn(name, fv.getType());
        this.ds.updateStringArray(name, value);
    }

    public void put(String name, Object value) {
        if (this.ds.getRowCount() == 0) {
            this.ds.appendRow();
        }
        this.ds.locateLine(1);
        FieldValue fv = this.fc.getFieldValue(value);
        this.ds.addColumn(name, fv.getType());
        this.ds.updateValue(name, value);
    }

    public IDataset getDataset() {
        return this.ds;
    }
}

