/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.dataset.convertor;

import com.hundsun.t2sdk.common.share.dataset.convertor.AtomicIntegerConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.AtomicLongConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.BigDecimalConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.BooleanConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.ByteArrayConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.ByteConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.CharConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.Convertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.DateConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.DefaultConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.DoubleConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.FloatConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.IntConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.LongConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.ShortConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.StringArrayConvertor;
import com.hundsun.t2sdk.common.share.dataset.convertor.StringConvertor;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertorRegistry {
    private static Map<Class<?>, Convertor<?>> innerConverts = new HashMap();
    private Map<Class<?>, Convertor<?>> convertors = new HashMap();

    public ConvertorRegistry() {
        this.convertors.putAll(innerConverts);
    }

    public ConvertorRegistry(ConvertorRegistry other) {
        this();
        this.convertors.putAll(other.convertors);
    }

    public <T> Convertor<?> registerConvertor(Class<T> clz, Convertor<?> convertor) {
        return this.convertors.put(clz, convertor);
    }

    public <T> Convertor<?> getConvertor(Class<T> clz) {
        Convertor<?> convertor = this.convertors.get(clz);
        if (convertor == null) {
            return new DefaultConvertor<T>(clz);
        }
        return convertor;
    }

    static {
        innerConverts.put(Integer.TYPE, new IntConvertor());
        innerConverts.put(Integer.class, new IntConvertor());
        innerConverts.put(Long.TYPE, new LongConvertor());
        innerConverts.put(Long.class, new LongConvertor());
        innerConverts.put(Short.TYPE, new ShortConvertor());
        innerConverts.put(Short.class, new ShortConvertor());
        innerConverts.put(Byte.TYPE, new ByteConvertor());
        innerConverts.put(Byte.class, new ByteConvertor());
        innerConverts.put(Boolean.TYPE, new BooleanConvertor());
        innerConverts.put(Boolean.class, new BooleanConvertor());
        innerConverts.put(Character.TYPE, new CharConvertor());
        innerConverts.put(Character.class, new CharConvertor());
        innerConverts.put(Double.TYPE, new DoubleConvertor());
        innerConverts.put(Double.class, new DoubleConvertor());
        innerConverts.put(Float.TYPE, new FloatConvertor());
        innerConverts.put(Float.class, new FloatConvertor());
        innerConverts.put(String.class, new StringConvertor());
        innerConverts.put(byte[].class, new ByteArrayConvertor());
        innerConverts.put(String[].class, new StringArrayConvertor());
        innerConverts.put(Date.class, new DateConvertor());
        innerConverts.put(BigDecimal.class, new BigDecimalConvertor());
        innerConverts.put(AtomicInteger.class, new AtomicIntegerConvertor());
        innerConverts.put(AtomicLong.class, new AtomicLongConvertor());
    }
}

