/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.event;

import com.hundsun.t2sdk.common.share.dataset.CommonDatasets;
import com.hundsun.t2sdk.common.share.util.EventUtils;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasets;
import com.hundsun.t2sdk.interfaces.share.event.IEvent;
import com.hundsun.t2sdk.interfaces.share.exception.DatasetRuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonEvent
implements IEvent {
    protected IDatasets eventBody = null;
    protected Map<String, Object> allTags = new HashMap<String, Object>();
    protected Map<String, Character> map2Type = new HashMap<String, Character>();
    protected List<String> vecTags = new ArrayList<String>();
    private static char SPLIT = (char)32;

    public CommonEvent() {
        long eventId = EventUtils.getInstance().generateEventNo();
        this.setIntegerAttributeValue("11", eventId);
        this.setIntegerAttributeValue("13", 8L);
    }

    @Override
    public int getEventType() {
        int eventType = (int)this.getIntegerAttributeValue("3");
        return eventType;
    }

    public void prepare(String serviceId, int type) {
        this.setStringAttributeValue("75", serviceId);
        this.setIntegerAttributeValue("3", type);
    }

    public void prepareByAlias(String alias, int type) {
        this.setStringAttributeValue("5", alias);
        this.setIntegerAttributeValue("3", type);
    }

    @Override
    public int changeToresponse() {
        long iLiveTime;
        long eventType = this.getIntegerAttributeValue("3");
        if (eventType == 2L) {
            eventType = 3L;
        } else if (eventType == 0L) {
            eventType = 1L;
        } else {
            return 1;
        }
        this.setIntegerAttributeValue("3", eventType);
        if (this.hasAttribute("14")) {
            this.setIntegerAttributeValue("14", 16L);
        }
        if (this.hasAttribute("15") && (iLiveTime = this.getIntegerAttributeValue("15")) < 10L) {
            this.setIntegerAttributeValue("15", 10L);
        }
        String[] sendpath = this.getStringArrayAttributeValue("73");
        this.setStringArrayAttributeValue("74", sendpath);
        this.removeAttribute("73");
        if (this.hasAttribute("10")) {
            String[] cresSenderPath = this.getStringArrayAttributeValue("10");
            this.setStringArrayAttributeValue("9", cresSenderPath);
            this.removeAttribute("10");
        }
        this.eventBody = new CommonDatasets();
        return 0;
    }

    @Override
    public byte[] getByteArrayAttributeValue(String tagName) {
        Character type = this.map2Type.get(tagName);
        if (type != null && type.charValue() == 'R') {
            return (byte[])this.allTags.get(tagName);
        }
        return null;
    }

    @Override
    public String getErrorInfo() {
        String errorInfo = this.getStringAttributeValue("20");
        return errorInfo;
    }

    @Override
    public long getIntegerAttributeValue(String tagName) {
        Character type = this.map2Type.get(tagName);
        if (type != null && (type.charValue() == 'I' || type.charValue() == 'S')) {
            try {
                return Long.valueOf(this.allTags.get(tagName).toString());
            }
            catch (Exception e) {
                throw new DatasetRuntimeException(e.getMessage(), new Object[]{e});
            }
        }
        return 0L;
    }

    @Override
    public IDatasets getEventDatas() {
        return this.eventBody;
    }

    @Override
    public void putEventData(IDataset dataset) {
        if (this.eventBody == null) {
            this.eventBody = new CommonDatasets();
        }
        this.eventBody.putDataset(dataset);
    }

    @Override
    public void putEventDatas(IDatasets datasets) {
        if (this.eventBody == null) {
            this.eventBody = new CommonDatasets();
        }
        int size = datasets.getDatasetCount();
        for (int i = 0; i < size; ++i) {
            this.eventBody.putDataset(datasets.getDataset(i));
        }
    }

    @Override
    public int getReturnCode() {
        return (int)this.getIntegerAttributeValue("7");
    }

    @Override
    public String getServiceId() {
        return this.getStringAttributeValue("75");
    }

    @Override
    public String getServiceAlias() {
        return this.getStringAttributeValue("5");
    }

    @Override
    public String[] getStringArrayAttributeValue(String tagName) {
        Character type = this.map2Type.get(tagName);
        if (type != null && type.charValue() == 'A') {
            try {
                return (String[])this.allTags.get(tagName);
            }
            catch (Exception e) {
                throw new DatasetRuntimeException(e.getMessage(), new Object[]{e});
            }
        }
        return null;
    }

    @Override
    public String getStringAttributeValue(String tagName) {
        Character type = this.map2Type.get(tagName);
        if (type != null) {
            try {
                Object tag = this.allTags.get(tagName);
                if (tag == null) {
                    return null;
                }
                return tag.toString();
            }
            catch (Exception e) {
                throw new DatasetRuntimeException(e.getMessage(), new Object[]{e});
            }
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String tagName) {
        int index = this.vecTags.indexOf(tagName);
        return index != -1;
    }

    @Override
    public void setByteArrayAttributeValue(String tagName, byte[] value) {
        Character type;
        int index = this.vecTags.indexOf(tagName);
        if (index >= 0 && (type = this.map2Type.get(tagName)) != null && type.charValue() != 'R') {
            this.removeAttribute(tagName);
        }
        this.vecTags.add(tagName);
        this.map2Type.put(tagName, Character.valueOf('R'));
        this.allTags.put(tagName, value);
    }

    @Override
    public void setIntegerAttributeValue(String tagName, long value) {
        Character type;
        int index = this.vecTags.indexOf(tagName);
        if (index >= 0 && (type = this.map2Type.get(tagName)) != null && type.charValue() != 'I') {
            this.removeAttribute(tagName);
        }
        this.vecTags.add(tagName);
        this.map2Type.put(tagName, Character.valueOf('I'));
        this.allTags.put(tagName, value);
    }

    @Override
    public void setStringArrayAttributeValue(String tagName, String[] value) {
        Character type;
        int index = this.vecTags.indexOf(tagName);
        if (index >= 0 && (type = this.map2Type.get(tagName)) != null && type.charValue() != 'A') {
            this.removeAttribute(tagName);
        }
        this.vecTags.add(tagName);
        this.map2Type.put(tagName, Character.valueOf('A'));
        this.allTags.put(tagName, value);
    }

    @Override
    public void setStringAttributeValue(String tagName, String value) {
        Character type;
        int index = this.vecTags.indexOf(tagName);
        if (index >= 0 && (type = this.map2Type.get(tagName)) != null && type.charValue() != 'S') {
            this.removeAttribute(tagName);
        }
        this.vecTags.add(tagName);
        this.map2Type.put(tagName, Character.valueOf('S'));
        this.allTags.put(tagName, value);
    }

    @Override
    public <T> T getAttributeValue(String tagName) {
        return (T)this.allTags.get(tagName);
    }

    @Override
    public void setAttributeValue(String tagName, Object value) {
        Character type;
        int index = this.vecTags.indexOf(tagName);
        if (index >= 0 && (type = this.map2Type.get(tagName)) != null && type.charValue() != 'U') {
            this.removeAttribute(tagName);
        }
        this.vecTags.add(tagName);
        this.map2Type.put(tagName, Character.valueOf('U'));
        this.allTags.put(tagName, value);
    }

    @Override
    public void removeAttribute(String name) {
        int index = this.vecTags.indexOf(name);
        if (index >= 0) {
            this.vecTags.remove(index);
            this.map2Type.remove(name);
            this.allTags.remove(name);
        }
    }

    @Override
    public void setReturnCode(int returnCode) {
        this.setIntegerAttributeValue("7", returnCode);
    }

    @Override
    public int getAttributeCount() {
        return this.vecTags.size();
    }

    @Override
    public String getAttributeName(int index) {
        return this.vecTags.get(index);
    }

    @Override
    public char getAttributeType(String name) {
        Character type = this.map2Type.get(name);
        if (type != null) {
            return type.charValue();
        }
        return '\u0000';
    }

    @Override
    public void setErrorCode(String errorNo, String errorInfo) {
        Integer returnCode;
        if (!this.hasAttribute("7") && (returnCode = (Integer)this.getAttributeValue("7")) != null && returnCode == 0) {
            this.setIntegerAttributeValue("7", -1L);
        }
        this.setStringAttributeValue("19", errorNo);
        this.setStringAttributeValue("20", errorInfo);
    }

    @Override
    public String getErrorNo() {
        String errorNo;
        char type = this.getAttributeType("19");
        if ('I' == type) {
            return "" + this.getIntegerAttributeValue("19");
        }
        if ('S' == type && (errorNo = this.getStringAttributeValue("19")) != null) {
            return errorNo;
        }
        return "0";
    }

    @Override
    public void setEventType(int type) {
        this.setIntegerAttributeValue("3", type);
    }

    @Override
    public void setServiceAlias(String alias) {
        this.setStringAttributeValue("5", alias);
    }

    @Override
    public void setServiceId(String serviceId) {
        this.setStringAttributeValue("75", serviceId);
    }

    @Override
    public void addTimestamp(long time, String timestampInfo) {
        if (this.isTimestampOn()) {
            String[] stamps = this.getStringArrayAttributeValue("52");
            if (stamps == null) {
                stamps = new String[]{};
            }
            if (stamps != null) {
                int length = stamps.length;
                String[] newStamps = new String[length + 1];
                System.arraycopy(stamps, 0, newStamps, 0, length);
                StringBuffer sb = new StringBuffer(512);
                sb.append(time);
                sb.append(SPLIT);
                sb.append(timestampInfo);
                newStamps[length] = sb.toString();
                this.setStringArrayAttributeValue("52", newStamps);
            }
        }
    }

    @Override
    public String[] getTimestamp() {
        if (this.isTimestampOn()) {
            return this.getStringArrayAttributeValue("52");
        }
        return new String[0];
    }

    @Override
    public boolean isTimestampOn() {
        return this.hasAttribute("52");
    }

    @Override
    public void markTimestamp(boolean on) {
        if (!this.isTimestampOn() && on) {
            this.setStringArrayAttributeValue("52", new String[0]);
        } else if (this.isTimestampOn() && !on) {
            this.removeAttribute("52");
        }
    }

    public static void main(String[] args) {
        String.format("", 22);
        System.out.println(System.nanoTime());
        StringBuffer sb = new StringBuffer(512);
        sb.append(123456789);
        sb.append('\u0000');
        sb.append("\u65f6\u95f4\u6233");
        System.out.println(sb.toString());
        CommonEvent event = new CommonEvent();
        event.addTimestamp(System.nanoTime(), "no effective");
        String[] ss = event.getTimestamp();
        long start = System.nanoTime();
        event.markTimestamp(true);
        event.addTimestamp(System.nanoTime(), "1");
        event.addTimestamp(System.nanoTime(), "2");
        event.addTimestamp(System.nanoTime(), "3");
        ss = event.getTimestamp();
        System.out.println(System.nanoTime() - start);
        event.markTimestamp(false);
        ss = event.getTimestamp();
        System.out.println("00" + ss);
        System.out.println();
        StackTraceElement[] dd = Thread.currentThread().getStackTrace();
        for (int i = 0; i < dd.length; ++i) {
            System.out.println(dd[i].toString());
        }
    }
}

