/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.event;

import com.hundsun.t2sdk.common.share.dataset.CommonDatasets;
import com.hundsun.t2sdk.common.share.event.PackService;
import com.hundsun.t2sdk.common.share.util.ByteArrayStream;
import com.hundsun.t2sdk.common.share.util.IndexMap;
import com.hundsun.t2sdk.common.share.util.NodeNameParser;
import com.hundsun.t2sdk.common.share.util.StringUtil;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasets;
import com.hundsun.t2sdk.interfaces.share.event.IEvent;
import com.hundsun.t2sdk.interfaces.share.event.IPack;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jvcompress.lzo.MiniLZO;
import org.jvcompress.util.MInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonEvent_1
implements IEvent {
    private String IS_COMPRESS = "1";
    private Map<String, String> stringTag = new HashMap<String, String>();
    private Map<String, String[]> arrayTag = new HashMap<String, String[]>();
    private Map<String, byte[]> rawDataTag = new HashMap<String, byte[]>();
    private Map<String, Object> userDefineTag = new HashMap<String, Object>();
    private IndexMap<Character> map2Type = new IndexMap();
    private static final char SPLIT = '\u0000';
    private static final char EQUAL = '=';
    private boolean needPackEventBody = false;
    private boolean needUnpackEventBody = true;
    private String charset = "utf-8";
    private int packVersion = 2;
    private CommonDatasets eventBody;

    public CommonEvent_1() {
        this.setIntegerAttributeValue("13", 8L);
        this.needUnpackEventBody = false;
        this.needPackEventBody = true;
    }

    public CommonEvent_1(byte[] data, String charset) throws Exception {
        this();
        this.needPackEventBody = false;
        this.needUnpackEventBody = true;
        this.charset = charset;
        this.unpackAllTags(data, charset);
        this.adaptationAjustion(charset);
        if (!"utf-8".equalsIgnoreCase(charset)) {
            this.needPackEventBody = true;
            this.getEventDatas();
        }
    }

    protected boolean unpackAllTags(byte[] data, String charset) throws UnsupportedEncodingException {
        if (data == null) {
            return false;
        }
        int index = 0;
        while (index < data.length && (index = this.findEquIndex(data, index)) != -1) {
            byte[] tmp;
            int len;
            String tagName = this.findTagName(data, index, charset);
            if (StringUtil.equals("1", tagName)) {
                len = this.findStrLen(data, index);
                int byteLength = Integer.parseInt(new String(this.findStrData(data, index, len)));
                index += len + 1;
                index = this.findEquIndex(data, index);
                String byteTagName = this.findTagName(data, index, charset);
                tmp = new byte[byteLength];
                System.arraycopy(data, index + 1, tmp, 0, byteLength);
                this.setByteArrayAttributeValue(byteTagName, tmp);
                index += byteLength + 2;
                continue;
            }
            if (StringUtil.equals("2", tagName)) {
                len = this.findStrLen(data, index);
                int arrayLength = Integer.parseInt(new String(this.findStrData(data, index, len)));
                index += len + 1;
                index = this.findEquIndex(data, index);
                String arrayTagName = this.findTagName(data, index, charset);
                tmp = this.getArrayByte(data, index, arrayLength);
                String data1 = new String(tmp, charset);
                String[] array = data1.split("\u0000");
                if (array.length != arrayLength) {
                    String[] newArray = new String[array.length + 1];
                    for (int i = 0; i < array.length; ++i) {
                        newArray[i] = array[i];
                    }
                    array = newArray;
                    newArray = null;
                }
                this.setStringArrayAttributeValue(arrayTagName, array);
                index += tmp.length + 1;
                continue;
            }
            len = this.findStrLen(data, index);
            String value = new String(this.findStrData(data, index, len), charset);
            this.setStringAttributeValue(tagName, value);
            index += len + 1;
        }
        return true;
    }

    protected boolean adaptationAjustion(String charset) {
        int eventType;
        if (this.hasAttribute("5")) {
            this.setStringAttributeValue("5", this.getStringAttributeValue("5"));
        }
        if ((eventType = this.getEventType()) == 1 || eventType == 3) {
            if (this.hasAttribute("73")) {
                String[] sendpath = this.getStringArrayAttributeValue("73");
                this.setStringArrayAttributeValue("74", sendpath);
                this.removeAttribute("73");
            }
        } else if (this.hasAttribute("9") && !this.hasAttribute("74")) {
            String[] routeInfo;
            if (this.getStringArrayAttributeValue("9") != null && this.getStringArrayAttributeValue("9").length < 6) {
                routeInfo = new String[6];
                System.arraycopy(this.getStringArrayAttributeValue("9"), 0, routeInfo, 0, this.getStringArrayAttributeValue("9").length);
            } else {
                routeInfo = this.getStringArrayAttributeValue("9");
            }
            String[] jresRouteInfo = new String[5];
            String ospfName = routeInfo[0];
            NodeNameParser nodeNameParser = new NodeNameParser(ospfName);
            jresRouteInfo[0] = nodeNameParser.getNodeName();
            jresRouteInfo[4] = Integer.toString(nodeNameParser.getNodeNo());
            jresRouteInfo[3] = routeInfo[3];
            this.setStringArrayAttributeValue("74", jresRouteInfo);
        }
        return true;
    }

    protected CommonDatasets unpackEventBody(String charset) {
        CommonDatasets dss = this.eventBody;
        if (this.hasAttribute("8")) {
            byte[] dataMsgBody = this.getByteArrayAttributeValue("8");
            if (this.hasAttribute("43") && this.IS_COMPRESS.equals(this.getStringAttributeValue("43"))) {
                byte[] tmp = new byte[dataMsgBody.length * 3];
                MInt out_len = new MInt();
                int stat = MiniLZO.lzo1x_decompress(dataMsgBody, dataMsgBody.length, tmp, out_len);
                if (out_len.v > dataMsgBody.length * 3) {
                    tmp = new byte[out_len.v];
                    stat = MiniLZO.lzo1x_decompress(dataMsgBody, dataMsgBody.length, tmp, out_len);
                }
                if (stat == 0) {
                    dataMsgBody = new byte[out_len.v];
                    System.arraycopy(tmp, 0, dataMsgBody, 0, dataMsgBody.length);
                }
            }
            if (dataMsgBody != null) {
                if (dss == null) {
                    dss = new CommonDatasets();
                }
                IPack pack = PackService.getPacker(dataMsgBody, charset);
                this.packVersion = pack.getVersion();
                int datasetCount = pack.getDatasetCount();
                for (int i = 0; i < datasetCount; ++i) {
                    dss.putDataset(pack.getDataset(i));
                }
            }
        }
        return dss;
    }

    private int findEquIndex(byte[] data, int offset) {
        for (int index = offset; index < data.length; ++index) {
            if (data[index] != 61) continue;
            return index;
        }
        return -1;
    }

    private int findStrLen(byte[] data, int offset) {
        int index;
        for (index = offset + 1; index < data.length && data[index] != 0; ++index) {
        }
        return index - offset;
    }

    private byte[] findStrData(byte[] data, int offset, int length) {
        if (data[offset + length] == 0) {
            byte[] tmp = new byte[length - 1];
            System.arraycopy(data, offset + 1, tmp, 0, length - 1);
            return tmp;
        }
        byte[] tmp = new byte[length];
        System.arraycopy(data, offset + 1, tmp, 0, length);
        return tmp;
    }

    private String findTagName(byte[] data, int offset, String charset) {
        int index;
        for (index = offset - 1; index >= 0 && data[index] != 0; --index) {
        }
        if (index != 0) {
            byte[] tmp = new byte[offset - index - 1];
            System.arraycopy(data, index + 1, tmp, 0, offset - index - 1);
            try {
                return new String(tmp, charset);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return new String(tmp);
            }
        }
        byte[] tmp = new byte[offset];
        System.arraycopy(data, 0, tmp, 0, offset);
        try {
            return new String(tmp, charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new String(tmp);
        }
    }

    private byte[] getArrayByte(byte[] data, int offset, int count) {
        int length = 0;
        int tmpOffset = offset;
        for (int i = 0; i < count; ++i) {
            tmpOffset = offset + (length += this.findStrLen(data, tmpOffset));
        }
        byte[] tmp = new byte[length];
        System.arraycopy(data, offset + 1, tmp, 0, length);
        return tmp;
    }

    public byte[] packAllAttributes(String charset) throws Exception {
        byte[] dataMsgBody;
        this.adaptationAjustionForPack();
        if (this.needPackEventBody) {
            this.packEventBody(charset);
        } else if (!"utf-8".equalsIgnoreCase(charset) && (dataMsgBody = this.getByteArrayAttributeValue("8")) != null) {
            this.eventBody = this.unpackEventBody("utf-8");
            this.packEventBody(charset);
        }
        ByteArrayStream tagBuffer = new ByteArrayStream(200);
        this.packStringTags(tagBuffer, charset);
        this.packStringArrayTags(tagBuffer, charset);
        this.packByteArrayTags(tagBuffer, charset);
        byte[] buff = tagBuffer.toByteArray();
        return buff;
    }

    private void adaptationAjustionForPack() {
        int eventType = this.getEventType();
        String serviceAlias = this.getServiceAlias();
        if (serviceAlias != null) {
            this.setStringAttributeValue("5", serviceAlias);
        }
        if ((eventType == 0 || eventType == 2) && this.hasAttribute("74") && !this.hasAttribute("9")) {
            String[] jresRouteInfo = this.getStringArrayAttributeValue("74");
            String[] routeInfo = new String[6];
            routeInfo[0] = new StringBuilder(20).append(jresRouteInfo[0]).append("#").append(jresRouteInfo[1]).toString();
            routeInfo[3] = jresRouteInfo[3];
            routeInfo[4] = jresRouteInfo[2];
            this.setStringArrayAttributeValue("9", routeInfo);
        }
    }

    protected void packEventBody(String charset) {
        CommonDatasets dss = this.eventBody;
        if (dss != null) {
            int dssCount = dss.getDatasetCount();
            IPack packer = PackService.getPacker(this.packVersion, charset);
            for (int i = 0; i < dssCount; ++i) {
                IDataset ds;
                if (i == 0 && StringUtil.equals("8", this.getServiceAlias()) && this.getEventType() == 2 && (ds = dss.getDataset(i)) != null && ds.getRowCount() > 0) {
                    ds.locateLine(1);
                    if (ds.findColumn("pluginId") != 0) {
                        ds.addColumn("plugin_id");
                        ds.updateString("plugin_id", ds.getString("pluginId"));
                    }
                    if (ds.findColumn("commandName") != 0) {
                        ds.addColumn("function_id");
                        ds.updateString("function_id", ds.getString("commandName"));
                    }
                }
                packer.addDataset(dss.getDataset(i));
            }
            if (this.IS_COMPRESS.equals(this.getStringAttributeValue("43"))) {
                int[] dict = new int[131072];
                Arrays.fill(dict, 0);
                byte[] dataMsgBody = packer.Pack();
                int outLen = dataMsgBody.length + dataMsgBody.length / 16 + 64 + 3;
                byte[] tmp = new byte[outLen];
                MInt out_len = new MInt();
                int stat = MiniLZO.lzo1x_1_compress(dataMsgBody, dataMsgBody.length, tmp, out_len, dict);
                if (stat == 0) {
                    dataMsgBody = new byte[out_len.v];
                    System.arraycopy(tmp, 0, dataMsgBody, 0, dataMsgBody.length);
                    this.setByteArrayAttributeValue("8", dataMsgBody);
                }
            } else {
                this.setByteArrayAttributeValue("8", packer.Pack());
            }
        }
    }

    protected void packStringTags(ByteArrayStream outStream, String charset) throws UnsupportedEncodingException, IOException {
        int inStart = 100;
        int inEnd = 199;
        for (String tagName : this.stringTag.keySet()) {
            int tag = StringUtil.toInt(tagName, -1);
            if (tag > inStart && tag < inEnd || tag < 0) continue;
            String value = this.stringTag.get(tagName);
            outStream.write(tagName.getBytes(charset));
            outStream.write(61);
            if (value != null) {
                outStream.write(value.getBytes(charset));
            }
            outStream.write(0);
        }
    }

    protected void packStringArrayTags(ByteArrayStream outStream, String charset) throws Exception {
        int inStart = 100;
        int inEnd = 199;
        for (String tagName : this.arrayTag.keySet()) {
            String[] value;
            int tag = StringUtil.toInt(tagName, -1);
            if (tag > inStart && tag < inEnd || tag < 0 || (value = this.arrayTag.get(tagName)) == null) continue;
            outStream.write("2".getBytes());
            outStream.write(61);
            outStream.write(String.valueOf(value.length).getBytes());
            outStream.write(0);
            outStream.write(tagName.getBytes(charset));
            outStream.write(61);
            for (int i = 0; i < value.length; ++i) {
                if (value[i] != null && value[i].length() != 0) {
                    outStream.write(value[i].getBytes(charset));
                }
                outStream.write(0);
            }
        }
    }

    protected void packByteArrayTags(ByteArrayStream outStream, String charset) throws Exception {
        int inStart = 100;
        int inEnd = 199;
        for (String tagName : this.rawDataTag.keySet()) {
            int tag = StringUtil.toInt(tagName, -1);
            if (tag > inStart && tag < inEnd || tag < 0) continue;
            byte[] value = this.rawDataTag.get(tagName);
            outStream.write("1".getBytes());
            outStream.write(61);
            outStream.write(String.valueOf(value.length).getBytes());
            outStream.write(0);
            outStream.write(tagName.getBytes(charset));
            outStream.write(61);
            outStream.write(value);
            outStream.write(0);
        }
    }

    public void prepare(String serviceId, int type) {
        this.setStringAttributeValue("75", serviceId);
        this.setIntegerAttributeValue("3", type);
    }

    public void prepareByAlias(String alias, int type) {
        this.setStringAttributeValue("5", alias);
        this.setIntegerAttributeValue("3", type);
    }

    @Override
    public void addTimestamp(long time, String timestampInfo) {
        if (this.isTimestampOn()) {
            String[] stamps = this.getStringArrayAttributeValue("52");
            if (stamps == null) {
                stamps = new String[]{};
            }
            if (stamps != null) {
                int length = stamps.length;
                String[] newStamps = new String[length + 1];
                System.arraycopy(stamps, 0, newStamps, 0, length);
                StringBuffer sb = new StringBuffer(512);
                sb.append(time);
                if (time != 0L) {
                    sb.append("  ");
                    sb.append(timestampInfo);
                }
                newStamps[length] = sb.toString();
                this.setStringArrayAttributeValue("52", newStamps);
            }
        }
    }

    @Override
    public int changeToresponse() {
        byte[] dataMsgBody;
        long iLiveTime;
        long eventType = this.getIntegerAttributeValue("3") & 0xFFFFFFFFBFFFFFFFL;
        if (eventType == 2L) {
            ++eventType;
        } else if (eventType == 0L) {
            ++eventType;
        } else {
            return 1;
        }
        this.setIntegerAttributeValue("3", eventType);
        if (this.hasAttribute("14")) {
            this.setIntegerAttributeValue("14", 16L);
        }
        if (this.hasAttribute("15") && (iLiveTime = this.getIntegerAttributeValue("15")) < 10L) {
            this.setIntegerAttributeValue("15", 10L);
        }
        String[] sendpath = this.getStringArrayAttributeValue("73");
        this.setStringArrayAttributeValue("74", sendpath);
        this.removeAttribute("73");
        if (this.hasAttribute("10")) {
            String[] cresSenderPath = this.getStringArrayAttributeValue("10");
            this.setStringArrayAttributeValue("9", cresSenderPath);
            this.removeAttribute("10");
        }
        if ((dataMsgBody = this.getByteArrayAttributeValue("8")) != null) {
            this.packVersion = PackService.getVersion(dataMsgBody);
        }
        this.eventBody = null;
        return 0;
    }

    @Override
    public int getAttributeCount() {
        return this.map2Type.size();
    }

    @Override
    public String getAttributeName(int index) {
        Set<Map.Entry<String, Integer>> entitySet = this.map2Type.getMapping().entrySet();
        for (Map.Entry<String, Integer> entry : entitySet) {
            if (index != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public char getAttributeType(String name) {
        Character type = this.map2Type.get(name);
        if (type == null) {
            return '\u0000';
        }
        return type.charValue();
    }

    @Override
    public <T> T getAttributeValue(String attrName) {
        Object result = null;
        char type = this.getAttributeType(attrName);
        switch (type) {
            case 'A': {
                result = this.getStringArrayAttributeValue(attrName);
                break;
            }
            case 'R': {
                result = this.getByteArrayAttributeValue(attrName);
                break;
            }
            case 'I': {
                result = this.getIntegerAttributeValue(attrName);
                break;
            }
            case 'S': {
                result = this.getStringAttributeValue(attrName);
                break;
            }
            case 'U': {
                result = this.userDefineTag.get(attrName);
                break;
            }
        }
        return (T)result;
    }

    @Override
    public byte[] getByteArrayAttributeValue(String attrName) {
        return this.rawDataTag.get(attrName);
    }

    @Override
    public String getErrorInfo() {
        return this.getStringAttributeValue("20");
    }

    @Override
    public String getErrorNo() {
        String errorNo;
        char type = this.getAttributeType("19");
        if ('I' == type) {
            return "" + this.getIntegerAttributeValue("19");
        }
        if ('S' == type && (errorNo = this.getStringAttributeValue("19")) != null) {
            return errorNo;
        }
        return "0";
    }

    @Override
    public IDatasets getEventDatas() {
        if (this.needUnpackEventBody) {
            this.eventBody = this.unpackEventBody(this.charset);
            this.needUnpackEventBody = false;
        }
        if (this.eventBody == null) {
            this.eventBody = new CommonDatasets();
        }
        return this.eventBody;
    }

    @Override
    public int getEventType() {
        return (int)this.getIntegerAttributeValue("3");
    }

    @Override
    public long getIntegerAttributeValue(String attrName) {
        String value = this.stringTag.get(attrName);
        if (value != null) {
            return Long.parseLong(value);
        }
        return 0L;
    }

    @Override
    public int getReturnCode() {
        return (int)this.getIntegerAttributeValue("7");
    }

    @Override
    public String getServiceAlias() {
        return this.getStringAttributeValue("5");
    }

    @Override
    public String getServiceId() {
        return this.getStringAttributeValue("75");
    }

    @Override
    public String[] getStringArrayAttributeValue(String attrName) {
        String[] strs = this.arrayTag.get(attrName);
        if (strs == null) {
            String str = this.stringTag.get(attrName);
            if (str != null) {
                if ("9".equals(attrName)) {
                    String[] routeInfo = new String[6];
                    routeInfo[0] = str;
                    return routeInfo;
                }
                return new String[]{str};
            }
            return null;
        }
        return strs;
    }

    @Override
    public String getStringAttributeValue(String attrName) {
        return this.stringTag.get(attrName);
    }

    @Override
    public String[] getTimestamp() {
        if (this.isTimestampOn()) {
            return this.getStringArrayAttributeValue("52");
        }
        return new String[0];
    }

    @Override
    public boolean hasAttribute(String attrName) {
        return this.map2Type.get(attrName) != null;
    }

    @Override
    public boolean isTimestampOn() {
        return this.hasAttribute("52");
    }

    @Override
    public void markTimestamp(boolean on) {
        if (!this.isTimestampOn() && on) {
            this.setStringArrayAttributeValue("52", new String[0]);
        } else if (this.isTimestampOn() && !on) {
            this.removeAttribute("52");
        }
    }

    @Override
    public void putEventData(IDataset dataset) {
        this.eventBody = (CommonDatasets)this.getEventDatas();
        this.eventBody.putDataset(dataset);
        this.needPackEventBody = true;
    }

    @Override
    public void putEventDatas(IDatasets datasets) {
        this.eventBody = (CommonDatasets)this.getEventDatas();
        int size = datasets.getDatasetCount();
        for (int i = 0; i < size; ++i) {
            this.eventBody.putDataset(datasets.getDataset(i));
        }
        this.needPackEventBody = true;
    }

    @Override
    public void removeAttribute(String name) {
        Character type = this.map2Type.remove(name);
        if (type == null) {
            return;
        }
        switch (type.charValue()) {
            case 'A': {
                this.arrayTag.remove(name);
                break;
            }
            case 'R': {
                this.rawDataTag.remove(name);
                break;
            }
            case 'I': 
            case 'S': {
                this.stringTag.remove(name);
                break;
            }
            case 'U': {
                this.userDefineTag.remove(name);
            }
        }
    }

    @Override
    public void setAttributeValue(String attrName, Object value) {
        if (attrName != null) {
            Character type = this.map2Type.putAndReturn(attrName, Character.valueOf('U'));
            if (type != null) {
                this._removeAttribute(attrName, type.charValue());
            }
            this.userDefineTag.put(attrName, value);
        }
    }

    @Override
    public void setByteArrayAttributeValue(String attrName, byte[] value) {
        if (attrName != null) {
            Character type = this.map2Type.putAndReturn(attrName, Character.valueOf('R'));
            if (type != null) {
                this._removeAttribute(attrName, type.charValue());
            }
            this.rawDataTag.put(attrName, value);
        }
    }

    @Override
    public void setErrorCode(String errorNo, String errorInfo) {
        Integer returnCode;
        if (!this.hasAttribute("7") && (returnCode = (Integer)this.getAttributeValue("7")) != null && returnCode == 0) {
            this.setIntegerAttributeValue("7", -1L);
        }
        this.setStringAttributeValue("19", errorNo);
        this.setStringAttributeValue("20", errorInfo);
    }

    @Override
    public void setEventType(int type) {
        this.setIntegerAttributeValue("3", type);
    }

    @Override
    public void setIntegerAttributeValue(String attrName, long value) {
        if (attrName != null) {
            Character type = this.map2Type.putAndReturn(attrName, Character.valueOf('I'));
            if (type != null) {
                this._removeAttribute(attrName, type.charValue());
            }
            this.stringTag.put(attrName, Long.toString(value));
        }
    }

    private void _removeAttribute(String name, char type) {
        switch (type) {
            case 'A': {
                this.arrayTag.remove(name);
                break;
            }
            case 'R': {
                this.rawDataTag.remove(name);
                break;
            }
            case 'I': 
            case 'S': {
                this.stringTag.remove(name);
                break;
            }
            case 'U': {
                this.userDefineTag.remove(name);
            }
        }
    }

    @Override
    public void setReturnCode(int returnCode) {
        this.setIntegerAttributeValue("7", returnCode);
    }

    @Override
    public void setServiceAlias(String alias) {
        this.setStringAttributeValue("5", alias);
    }

    @Override
    public void setServiceId(String serviceId) {
        this.setStringAttributeValue("75", serviceId);
    }

    @Override
    public void setStringArrayAttributeValue(String attrName, String[] value) {
        if (attrName != null) {
            Character type = this.map2Type.putAndReturn(attrName, Character.valueOf('A'));
            if (type != null) {
                this._removeAttribute(attrName, type.charValue());
            }
            this.arrayTag.put(attrName, value);
        }
    }

    @Override
    public void setStringAttributeValue(String attrName, String value) {
        if (attrName != null) {
            Character type = this.map2Type.putAndReturn(attrName, Character.valueOf('S'));
            if (type != null) {
                this._removeAttribute(attrName, type.charValue());
            }
            this.stringTag.put(attrName, value);
        }
    }
}

