/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.event.field;

import com.hundsun.t2sdk.common.share.event.field.Field;
import com.hundsun.t2sdk.common.share.event.field.FieldValue;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasetAttribute;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldCreator {
    private static Map<Integer, Integer> typeMap = new HashMap<Integer, Integer>();
    private IDatasetAttribute dssa;

    private FieldCreator(IDatasetAttribute dssa) {
        this.dssa = dssa;
    }

    public static FieldCreator getNewInstance(IDatasetAttribute dssa) {
        return new FieldCreator(dssa);
    }

    public Field getField(String name, int type) {
        Integer baseType = typeMap.get(type);
        char interType = baseType == null ? (char)'S' : (char)((char)baseType.intValue());
        return new Field(name, interType);
    }

    public FieldValue getDefaultValue(int type) {
        Integer baseType = typeMap.get(type);
        int interType = baseType == null ? 83 : (int)((char)baseType.intValue());
        switch (interType) {
            case 82: {
                return new FieldValue(this.dssa.getDefBytes(), this.dssa);
            }
            case 68: {
                return new FieldValue(this.dssa.getDefDouble(), this.dssa);
            }
            case 73: {
                return new FieldValue(this.dssa.getDefInt(), this.dssa);
            }
            case 76: {
                return new FieldValue(this.dssa.getDefLong(), this.dssa);
            }
            case 65: {
                return new FieldValue(this.dssa.getDefStrings(), this.dssa);
            }
        }
        return new FieldValue(this.dssa.getDefString(), this.dssa);
    }

    public FieldValue getFieldValue(byte[] value) {
        if (value == null) {
            value = this.dssa.getDefBytes();
        }
        return new FieldValue(value, this.dssa);
    }

    public FieldValue getFieldValue(int value) {
        return new FieldValue(value, this.dssa);
    }

    public FieldValue getFieldValue(long value) {
        return new FieldValue(value, this.dssa);
    }

    public FieldValue getFieldValue(String value) {
        if (value == null) {
            value = this.dssa.getDefString();
        }
        return new FieldValue(value, this.dssa);
    }

    public FieldValue getFieldValue(String[] value) {
        if (value == null) {
            value = this.dssa.getDefStrings();
        }
        return new FieldValue(value, this.dssa);
    }

    public FieldValue getFieldValue(double value) {
        return new FieldValue(value, this.dssa);
    }

    public FieldValue getFieldValue(Object value) {
        if (value == null) {
            return new FieldValue();
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal || value instanceof Float || value instanceof Double) {
                return new FieldValue(Double.valueOf(value.toString()), this.dssa);
            }
            if (value instanceof Long) {
                return new FieldValue((Long)value, this.dssa);
            }
            return new FieldValue(Integer.valueOf(value.toString()), this.dssa);
        }
        if (value instanceof byte[]) {
            return new FieldValue((byte[])value, this.dssa);
        }
        if (value instanceof String[]) {
            return new FieldValue((String[])value, this.dssa);
        }
        if (value instanceof Character) {
            return new FieldValue(value.toString(), this.dssa);
        }
        if (value instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat(this.dssa.getDateFormat());
            return new FieldValue(formatter.format(value), this.dssa);
        }
        if (value instanceof Calendar) {
            SimpleDateFormat formatter = new SimpleDateFormat(this.dssa.getDateFormat());
            return new FieldValue(formatter.format(((Calendar)value).getTime()), this.dssa);
        }
        if (value instanceof Locale) {
            return new FieldValue(value.toString(), this.dssa);
        }
        if (value instanceof Enum) {
            return new FieldValue(((Enum)value).name(), this.dssa);
        }
        if (value instanceof Boolean) {
            return new FieldValue((Boolean)value, this.dssa);
        }
        if (value instanceof Clob) {
            String clobStr = "";
            Clob clob = (Clob)value;
            try {
                clobStr = this.dssa.getMaxClobLength() == 0 || (long)this.dssa.getMaxClobLength() >= clob.length() ? clob.getSubString(1L, (int)clob.length()) : clob.getSubString(1L, this.dssa.getMaxClobLength()) + "...";
            }
            catch (SQLException e) {
                e.printStackTrace();
                clobStr = "";
            }
            return new FieldValue(clobStr, this.dssa);
        }
        if (value instanceof Blob) {
            String blobStr = "";
            Blob blob = (Blob)value;
            try {
                if (this.dssa.getMaxBlobLength() == 0 || (long)this.dssa.getMaxBlobLength() >= blob.length()) {
                    blobStr = new String(blob.getBytes(1L, (int)blob.length()));
                } else {
                    blobStr = new String(blob.getBytes(1L, this.dssa.getMaxBlobLength()));
                    blobStr = blobStr + "...";
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                blobStr = "";
            }
            return new FieldValue(blobStr, this.dssa);
        }
        return new FieldValue(value.toString(), this.dssa);
    }

    public static Map<Integer, Integer> getTypeMap() {
        return typeMap;
    }

    static {
        typeMap.put(82, 82);
        typeMap.put(68, 68);
        typeMap.put(73, 73);
        typeMap.put(76, 76);
        typeMap.put(83, 83);
        typeMap.put(65, 65);
        typeMap.put(2004, 82);
        typeMap.put(2005, 83);
        typeMap.put(1, 73);
        typeMap.put(91, 65);
        typeMap.put(3, 68);
        typeMap.put(8, 68);
        typeMap.put(6, 68);
        typeMap.put(4, 76);
        typeMap.put(2, 68);
        typeMap.put(7, 68);
        typeMap.put(-6, 73);
        typeMap.put(92, 83);
        typeMap.put(12, 83);
    }
}

