/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.event.field;

import com.hundsun.t2sdk.common.share.dataset.DatasetAttribute;
import com.hundsun.t2sdk.interfaces.share.dataset.DatasetColumnType;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasetAttribute;
import com.hundsun.t2sdk.interfaces.share.exception.DatasetRuntimeException;

public class FieldValue
implements DatasetColumnType {
    private final char DEFAULT_TYPE = (char)84;
    private final char BOOLEAN_TYPE = (char)66;
    private char type = (char)78;
    private Object value = null;
    private IDatasetAttribute dssa;

    protected FieldValue() {
        this.type = (char)84;
    }

    protected FieldValue(byte[] value, IDatasetAttribute dssa) {
        if (value == null) {
            value = new byte[]{};
        }
        if (dssa == null) {
            dssa = new DatasetAttribute();
        }
        this.type = (char)82;
        this.value = value;
        this.dssa = dssa;
    }

    protected FieldValue(String value, IDatasetAttribute dssa) {
        if (value == null) {
            value = "";
        }
        if (dssa == null) {
            dssa = new DatasetAttribute();
        }
        this.type = (char)83;
        this.value = value;
        this.dssa = dssa;
    }

    protected FieldValue(String[] value, IDatasetAttribute dssa) {
        if (value == null) {
            value = new String[]{};
        }
        if (dssa == null) {
            dssa = new DatasetAttribute();
        }
        this.type = (char)65;
        this.value = value;
        this.dssa = dssa;
    }

    protected FieldValue(int value, IDatasetAttribute dssa) {
        if (dssa == null) {
            dssa = new DatasetAttribute();
        }
        this.type = (char)73;
        this.value = value;
        this.dssa = dssa;
    }

    protected FieldValue(long value, IDatasetAttribute dssa) {
        if (dssa == null) {
            dssa = new DatasetAttribute();
        }
        this.type = (char)76;
        this.value = value;
        this.dssa = dssa;
    }

    protected FieldValue(double value, IDatasetAttribute dssa) {
        if (dssa == null) {
            dssa = new DatasetAttribute();
        }
        this.type = (char)68;
        this.value = value;
        this.dssa = dssa;
    }

    protected FieldValue(boolean value, IDatasetAttribute dssa) {
        if (dssa == null) {
            dssa = new DatasetAttribute();
        }
        this.type = (char)66;
        this.value = value;
        this.dssa = dssa;
    }

    public byte[] getByteArray() {
        return this.getByteArray(this.dssa.getDefBytes());
    }

    public byte[] getByteArray(byte[] def) {
        if (this.type == 'R') {
            return (byte[])this.value;
        }
        if (this.type == 'S' || this.type == 'D' || this.type == 'I' || this.type == 'L') {
            return this.value.toString().getBytes();
        }
        if (this.useDefaultValue()) {
            return def;
        }
        throw new DatasetRuntimeException("70", this.shortData(), "byte[]");
    }

    public String getString() {
        return this.getString(this.dssa.getDefString());
    }

    public String getString(String def) {
        if (this.type == 'S') {
            return this.value.toString();
        }
        if (this.type == 'B') {
            return this.value.toString();
        }
        if (this.type == 'R') {
            return new String((byte[])this.value);
        }
        if (this.type == 'D' || this.type == 'I' || this.type == 'L') {
            return this.value.toString();
        }
        if (this.useDefaultValue()) {
            return def;
        }
        throw new DatasetRuntimeException("70", this.shortData(), "string");
    }

    public String[] getStringArray() {
        return this.getStringArray(this.dssa.getDefStrings());
    }

    public String[] getStringArray(String[] def) {
        if (this.type == 'A') {
            return (String[])this.value;
        }
        if (this.type == 'R') {
            return new String[]{new String((byte[])this.value)};
        }
        if (this.type == 'D' || this.type == 'I' || this.type == 'L') {
            return new String[]{this.value.toString()};
        }
        if (this.useDefaultValue()) {
            return def;
        }
        throw new DatasetRuntimeException("70", this.shortData(), "string");
    }

    public int getInt() {
        return this.getInt(this.dssa.getDefInt());
    }

    public int getInt(int def) {
        if (this.useDefaultValue()) {
            return def;
        }
        if (this.type == 'I') {
            return (Integer)this.value;
        }
        if (this.type == 'D') {
            try {
                Double d = (Double)this.value;
                return d.intValue();
            }
            catch (Exception e) {
                throw new DatasetRuntimeException("70", this.shortData(), "int");
            }
        }
        if (this.type == 'B') {
            boolean v = (Boolean)this.value;
            if (v) {
                return 1;
            }
            return 0;
        }
        try {
            return Integer.parseInt(this.value.toString());
        }
        catch (Exception e) {
            Double d = this.attempt2Transform();
            if (d == null) {
                throw new DatasetRuntimeException("70", this.shortData(), "int");
            }
            return d.intValue();
        }
    }

    public long getLong() {
        return this.getLong(this.dssa.getDefLong());
    }

    public long getLong(long def) {
        if (this.useDefaultValue()) {
            return def;
        }
        if (this.type == 'L') {
            return (Long)this.value;
        }
        if (this.type == 'D') {
            try {
                Double d = (Double)this.value;
                return d.longValue();
            }
            catch (Exception e) {
                throw new DatasetRuntimeException("70", this.shortData(), "long");
            }
        }
        if (this.type == 'B') {
            boolean v = (Boolean)this.value;
            if (v) {
                return 1L;
            }
            return 0L;
        }
        try {
            return Long.parseLong(this.value.toString());
        }
        catch (Exception e) {
            Double d = this.attempt2Transform();
            if (d == null) {
                throw new DatasetRuntimeException("70", this.shortData(), "long");
            }
            return d.longValue();
        }
    }

    public double getDouble() {
        return this.getDouble(this.dssa.getDefDouble());
    }

    public double getDouble(double def) {
        if (this.useDefaultValue()) {
            return def;
        }
        if (this.type == 'D') {
            return (Double)this.value;
        }
        try {
            return Double.parseDouble(this.value.toString());
        }
        catch (Exception e) {
            throw new DatasetRuntimeException("70", this.shortData(), "double");
        }
    }

    public char getType() {
        char type = this.type;
        if (type == 'B') {
            type = 'S';
        }
        return (char)type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean useDefaultValue() {
        return 'T' == this.type;
    }

    protected Double attempt2Transform() {
        try {
            Double d = Double.parseDouble(this.value.toString());
            return d;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String shortData() {
        StringBuffer sb = new StringBuffer();
        if (this.type == 'R') {
            sb.append("byte[] -- " + new String((byte[])this.value));
        } else if (this.type == 'A') {
            String[] tmp;
            sb.append("String[] -- ");
            for (String str : tmp = (String[])this.value) {
                sb.append(str);
                sb.append("_@I@_");
            }
        } else {
            sb.append(this.value);
        }
        String print = sb.toString();
        if (print.length() > 100) {
            String t = print.substring(0, 100) + " ...";
            return t;
        }
        return print;
    }

    public static void main(String[] args) {
        FieldValue fv = new FieldValue(false, null);
        System.out.println(fv.getString());
        System.out.println(fv.getInt());
        Boolean vv = false;
        boolean bv = vv;
        System.out.println(bv);
        vv = Boolean.TRUE;
        bv = vv;
        System.out.println(bv);
    }
}

