/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.event.pack;

import com.hundsun.t2sdk.common.share.dataset.DatasetService;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasetAttribute;
import com.hundsun.t2sdk.interfaces.share.event.IPack;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class PackV1
implements IPack {
    private String charset = "UTF-8";
    private IDataset dataset = null;
    private byte[] data = null;
    private boolean isPack = false;
    private boolean isUnpack = false;

    public PackV1(String charset) {
        this.setCharset(charset);
    }

    public PackV1(byte[] data, String charset) {
        this.setCharset(charset);
        this.data = data;
        this.unPack(data);
    }

    public byte[] Pack() {
        if (this.isPack) {
            return this.data;
        }
        this.isPack = this.doPack();
        return this.data;
    }

    private boolean doPack() {
        this.isPack = false;
        this.data = null;
        if (this.dataset == null) {
            return false;
        }
        ByteArrayOutputStream bytebuf = new ByteArrayOutputStream();
        int col = this.dataset.getColumnCount();
        int row = this.dataset.getRowCount();
        try {
            bytebuf.write(String.valueOf(col).getBytes());
            bytebuf.write(1);
            bytebuf.write(String.valueOf(row).getBytes());
            bytebuf.write(1);
            for (int i = 1; i <= col; ++i) {
                bytebuf.write(this.dataset.getColumnName(i).getBytes(this.charset));
                bytebuf.write(1);
            }
            IDatasetAttribute dssa = DatasetService.getDatasetAttribute(this.dataset);
            this.dataset.beforeFirst();
            while (this.dataset.hasNext()) {
                this.dataset.next();
                for (int j = 1; j <= col; ++j) {
                    char type = this.dataset.getColumnType(j);
                    String name = this.dataset.getColumnName(j);
                    Object obj = this.dataset.getValue(name);
                    if (obj != null) {
                        bytebuf.write(this.dataset.getString(name).getBytes(this.charset));
                    } else if (type == 'I') {
                        bytebuf.write(Integer.valueOf(dssa.getDefInt()).toString().getBytes());
                    } else if (type == 'L') {
                        bytebuf.write(Long.valueOf(dssa.getDefLong()).toString().getBytes());
                    } else if (type == 'D') {
                        bytebuf.write(Double.valueOf(dssa.getDefDouble()).toString().getBytes());
                    }
                    bytebuf.write(1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.data = bytebuf.toByteArray();
        return true;
    }

    public void addDataset(IDataset result) {
        this.dataset = result;
        this.isUnpack = false;
    }

    public void clear() {
        this.data = null;
        this.dataset = null;
        this.isPack = false;
        this.isUnpack = false;
    }

    public IDataset getDataset(int resultIndex) {
        if (resultIndex == 0) {
            if (!this.isUnpack) {
                this.unPack(this.data);
            }
            return this.dataset;
        }
        return null;
    }

    public int getDatasetCount() {
        if (this.isUnpack) {
            return 1;
        }
        if (this.unPack(this.data)) {
            return 1;
        }
        return 0;
    }

    public int getVersion() {
        return 1;
    }

    public boolean unPack(byte[] data) {
        this.isUnpack = false;
        this.dataset = null;
        if (data == null) {
            return false;
        }
        IDataset commonDataset = DatasetService.getDefaultInstance().getDataset();
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        int i = 0;
        for (int j = 0; j < data.length; ++j) {
            if (data[j] != 1) continue;
            byte[] tmp = new byte[j - i];
            if (tmp.length > 0) {
                System.arraycopy(data, i, tmp, 0, j - i);
            }
            result.add(tmp);
            i = j + 1;
        }
        int col = Integer.parseInt(new String((byte[])result.get(0)).trim());
        int row = Integer.parseInt(new String((byte[])result.get(1)).trim());
        if (result.size() - 2 - col != col * row) {
            result.clear();
            result = null;
            return false;
        }
        for (int i2 = 0; i2 < col; ++i2) {
            String colname = "";
            try {
                colname = new String((byte[])result.get(i2 + 2), this.charset);
            }
            catch (UnsupportedEncodingException e) {
                colname = new String((byte[])result.get(i2 + 2));
                e.printStackTrace();
            }
            commonDataset.addColumn(colname, 83);
        }
        int index = 2 + col;
        for (int i3 = 0; i3 < row; ++i3) {
            commonDataset.appendRow();
            for (int j = 0; j < col; ++j) {
                try {
                    commonDataset.updateString(j + 1, new String((byte[])result.get(index++), this.charset));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        this.isUnpack = true;
        this.dataset = commonDataset;
        this.data = data;
        return this.isUnpack;
    }

    public void setCharset(String charset) {
        this.charset = charset;
        if (charset == null || charset.equals("")) {
            this.charset = "UTF-8";
        }
        try {
            new String("\u9738\u5929\u864e".getBytes(), this.charset);
        }
        catch (UnsupportedEncodingException e) {
            this.charset = "UTF-8";
            e.printStackTrace();
        }
    }

    public static void main1(String[] args) {
        IDataset personDataset = DatasetService.getDefaultInstance().getDataset();
        personDataset.addColumn("name", 83);
        personDataset.addColumn("age", 73);
        personDataset.addColumn("sex", 73);
        personDataset.addColumn("salary", 68);
        personDataset.addColumn("picture", 82);
        personDataset.addColumn("favor", 65);
        personDataset.addColumn("address", 83);
        personDataset.appendRow();
        personDataset.updateString("name", "John");
        personDataset.updateInt("age", 24);
        personDataset.updateDouble("salary", 15000.0);
        personDataset.appendRow();
        personDataset.updateString(1, "Lucy");
        personDataset.updateInt(2, 25);
        personDataset.updateInt(3, 70);
        personDataset.updateDouble(4, 20000.25);
        personDataset.updateByteArray(5, new byte[]{49, 50, 51, 52, 53});
        personDataset.updateStringArray(6, new String[]{"\u7fbd\u6bdb\u7403", "\u770b\u4e66", "\u542c\u6b4c"});
        personDataset.addColumn("status", 73);
        PackV1.printDataset(personDataset);
        System.out.println("\n------------------------------\n");
        PackV1 v1 = new PackV1(null);
        v1.addDataset(personDataset);
        byte[] bytes = v1.Pack();
        if (bytes != null && v1.unPack(bytes)) {
            v1.getDatasetCount();
            PackV1.printDataset(v1.getDataset(0));
        }
    }

    private static void printDataset(IDataset ds) {
        int j;
        StringBuilder sb = new StringBuilder();
        int columnCount = ds.getColumnCount();
        for (j = 1; j <= columnCount; ++j) {
            sb.append("# " + j + "\t");
            sb.append(ds.getColumnName(j));
            sb.append("\t");
            sb.append(ds.getColumnType(j) + "\n");
        }
        ds.beforeFirst();
        while (ds.hasNext()) {
            ds.next();
            for (j = 1; j <= columnCount; ++j) {
                sb.append("|" + ds.getString(ds.getColumnName(j)) + "\t");
            }
            sb.append("\n");
        }
        System.out.println(sb.toString());
    }

    public static void main(String[] args) {
        System.out.println(Integer.parseInt("00001"));
    }
}

