/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.event.pack;

import com.hundsun.t2sdk.common.share.dataset.DatasetService;
import com.hundsun.t2sdk.common.share.util.ByteArrayStream;
import com.hundsun.t2sdk.common.share.util.ByteArrayUtil;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasetAttribute;
import com.hundsun.t2sdk.interfaces.share.event.IPack;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class PackV2
implements IPack {
    public static int MAX_BYTES_LENGTH = 0x4000000;
    private ArrayList<IDataset> datasets = new ArrayList();
    private byte[] data = null;
    private boolean isPack = false;
    private boolean isUnpack = false;
    private String charset = "UTF-8";

    public PackV2(String charset) {
        this.setCharset(charset);
    }

    public PackV2(byte[] data, String charset) {
        this.setCharset(charset);
        this.data = data;
        this.unPack(data);
    }

    public byte[] Pack() {
        int k;
        if (this.isPack) {
            return this.data;
        }
        ByteArrayStream tmpBuffer = new ByteArrayStream();
        tmpBuffer.write(33);
        tmpBuffer.write(0);
        tmpBuffer.write(3);
        boolean iNeedAppend = false;
        int[] totalCounts = new int[this.datasets.size()];
        for (k = 0; k < this.datasets.size(); ++k) {
            int totalCount;
            IDataset ds = this.datasets.get(k);
            if (ds == null) continue;
            if ("PLATFORM_PARAMETER_DATASET_NAME".equals(ds.getDatasetName())) {
                iNeedAppend = false;
                break;
            }
            totalCounts[k] = totalCount = ds.getTotalCount();
            if (totalCount == -1 || iNeedAppend) continue;
            iNeedAppend = true;
        }
        if (iNeedAppend && totalCounts.length > 0) {
            IDataset parameters = DatasetService.getDefaultInstance().getDataset();
            parameters.setDatasetName("PLATFORM_PARAMETER_DATASET_NAME");
            parameters.addColumn("totalCount");
            for (int tt : totalCounts) {
                parameters.appendRow();
                parameters.updateInt("totalCount", tt);
            }
            this.datasets.add(parameters);
        }
        for (k = 0; k < this.datasets.size(); ++k) {
            byte[] result = this.packDataset(this.datasets.get(k));
            if (result == null) continue;
            tmpBuffer.write(result);
        }
        this.data = tmpBuffer.toByteArray();
        this.data[1] = (byte)this.datasets.size();
        this.isPack = true;
        return this.data;
    }

    private byte[] packDataset(IDataset ds) {
        ByteArrayStream tmpBuffer = new ByteArrayStream();
        String datasetName = null;
        String charset = this.charset;
        try {
            datasetName = ds.getDatasetName();
            if (datasetName == null || datasetName.equals("")) {
                tmpBuffer.write(0);
            } else {
                tmpBuffer.write(datasetName.getBytes(charset));
                tmpBuffer.write(0);
            }
            int col = ds.getColumnCount();
            tmpBuffer.write(ByteArrayUtil.intToByteArray_C(col));
            int row = ds.getRowCount();
            tmpBuffer.write(ByteArrayUtil.intToByteArray_C(row));
            tmpBuffer.write(ByteArrayUtil.intToByteArray_C(0));
            tmpBuffer.write(ByteArrayUtil.intToByteArray_C(0));
            for (int i = 1; i <= col; ++i) {
                tmpBuffer.write(ds.getColumnName(i).getBytes(charset));
                tmpBuffer.write(0);
                char type = ds.getColumnType(i);
                if (charset.equalsIgnoreCase("GBK") && type == 'L') {
                    tmpBuffer.write(73);
                } else {
                    tmpBuffer.write(ds.getColumnType(i));
                }
                tmpBuffer.write(ByteArrayUtil.intToByteArray_C(MAX_BYTES_LENGTH));
                tmpBuffer.write(100);
            }
            IDatasetAttribute dssa = DatasetService.getDatasetAttribute(ds);
            ds.beforeFirst();
            while (ds.hasNext()) {
                ds.next();
                for (int j = 1; j <= col; ++j) {
                    String colName = ds.getColumnName(j);
                    char type = ds.getColumnType(j);
                    if (type == 'R') {
                        byte[] bytes = ds.getByteArray(colName);
                        if (bytes == null) {
                            bytes = new byte[]{};
                        }
                        tmpBuffer.write(ByteArrayUtil.intToByteArray_C(bytes.length));
                        tmpBuffer.write(bytes);
                        tmpBuffer.write(0);
                        continue;
                    }
                    Object obj = ds.getValue(colName);
                    if (obj != null) {
                        String value = ds.getString(colName);
                        tmpBuffer.write(value.getBytes(charset));
                    } else if (type == 'I') {
                        tmpBuffer.write(Integer.valueOf(dssa.getDefInt()).toString().getBytes());
                    } else if (type == 'L') {
                        tmpBuffer.write(Long.valueOf(dssa.getDefLong()).toString().getBytes());
                    } else if (type == 'D') {
                        tmpBuffer.write(Double.valueOf(dssa.getDefDouble()).toString().getBytes());
                    }
                    tmpBuffer.write(0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        byte[] tmp = tmpBuffer.toByteArray();
        int datasetLen = 0;
        if (datasetName == null) {
            datasetLen = tmp.length - 17;
            ByteArrayUtil.intToByteArray_C(datasetLen, tmp, 9);
        } else {
            try {
                datasetLen = tmp.length - datasetName.getBytes(charset).length - 17;
                ByteArrayUtil.intToByteArray_C(datasetLen, tmp, datasetName.getBytes(charset).length + 9);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return tmp;
    }

    public void addDataset(IDataset result) {
        if (result != null) {
            this.datasets.add(result);
            this.isPack = false;
        }
    }

    public void clear() {
        this.data = null;
        this.datasets.clear();
        this.isPack = false;
        this.isUnpack = false;
    }

    public IDataset getDataset(int resultIndex) {
        int size = this.getDatasetCount();
        if (resultIndex >= size) {
            return null;
        }
        return this.datasets.get(resultIndex);
    }

    public int getDatasetCount() {
        if (!this.isUnpack) {
            this.unPack(this.data);
        }
        return this.datasets.size();
    }

    public int getVersion() {
        return 2;
    }

    public boolean unPack(byte[] data) {
        String charset = this.charset;
        this.isUnpack = false;
        this.datasets.clear();
        if (data == null) {
            return false;
        }
        try {
            int datasetCount = ByteArrayUtil.byteToInt(data[1]);
            int i = 3;
            while (i < data.length) {
                IDataset ds = DatasetService.getDefaultInstance().getDataset();
                int nameLen = this.findDatasetName(ds, i);
                int col = ByteArrayUtil.byteArrayToInt_C(data, i += nameLen);
                int row = ByteArrayUtil.byteArrayToInt_C(data, i += 4);
                int dataSetLen = ByteArrayUtil.byteArrayToInt_C(data, i += 4);
                int returnCode = ByteArrayUtil.byteArrayToInt_C(data, i += 4);
                i += 4;
                int strLen = 0;
                ArrayList<Character> types = new ArrayList<Character>();
                for (int j = 0; j < col; ++j) {
                    strLen = this.findStringLen(i);
                    String colName = null;
                    try {
                        colName = new String(data, i, strLen - 1, charset);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        colName = new String(data, i, strLen - 1);
                    }
                    int colType = data[i += strLen];
                    int colWidth = ByteArrayUtil.byteArrayToInt_C(data, ++i);
                    int colScale = ByteArrayUtil.byteToInt(data[i += 4]);
                    ++i;
                    types.add(Character.valueOf((char)colType));
                    if (colType == 67) {
                        colType = 83;
                    } else if (colType == 73) {
                        colType = 76;
                    }
                    ds.addColumn(colName, colType);
                }
                for (int k = 1; k <= row; ++k) {
                    byte[] temp = null;
                    ds.appendRow();
                    for (int j = 1; j <= col; ++j) {
                        int binLength;
                        char type = ((Character)types.get(j - 1)).charValue();
                        if ('R' == type) {
                            binLength = ByteArrayUtil.byteArrayToInt_C(data, i);
                            temp = new byte[binLength];
                            System.arraycopy(data, i += 4, temp, 0, binLength);
                            i += binLength + 1;
                            ds.updateByteArray(j, temp);
                            continue;
                        }
                        if ('C' == type) {
                            binLength = 1;
                            temp = new byte[1];
                            System.arraycopy(data, i, temp, 0, binLength);
                            i += 2;
                            ds.updateString(j, String.valueOf((char)temp[0]));
                            continue;
                        }
                        binLength = this.findStringLen(i);
                        temp = new byte[binLength - 1];
                        System.arraycopy(data, i, temp, 0, binLength - 1);
                        i += binLength;
                        ds.updateString(j, new String(temp, charset));
                    }
                }
                if ("PLATFORM_PARAMETER_DATASET_NAME".equals(ds.getDatasetName())) {
                    int rowCount = ds.getRowCount();
                    if (this.datasets.size() < rowCount) continue;
                    for (int k = 1; k <= rowCount; ++k) {
                        ds.locateLine(k);
                        this.datasets.get(k - 1).setTotalCount(ds.getInt("totalCount", -1));
                    }
                    continue;
                }
                this.datasets.add(ds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.datasets.clear();
            return false;
        }
        this.isUnpack = true;
        this.data = data;
        return this.isUnpack;
    }

    private int findDatasetName(IDataset dataset, int offset) {
        int length = this.findStringLen(offset);
        try {
            dataset.setDatasetName(new String(this.data, offset, length - 1, this.charset));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            dataset.setDatasetName(new String(this.data, offset, length - 1));
        }
        return length;
    }

    private int findStringLen(int offset) {
        int length = 0;
        while (this.data[offset + length] != 0) {
            ++length;
        }
        return ++length;
    }

    public void setCharset(String charset) {
        this.charset = charset;
        if (charset == null || charset.equals("")) {
            this.charset = "UTF-8";
        }
        try {
            new String("\u9738\u5929\u864e".getBytes(), this.charset);
        }
        catch (UnsupportedEncodingException e) {
            this.charset = "UTF-8";
            e.printStackTrace();
        }
    }
}

