/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.pool;

import com.hundsun.t2sdk.common.share.queue.AtomQueue;
import com.hundsun.t2sdk.common.share.queue.SemaphoreQueue;
import com.hundsun.t2sdk.interfaces.share.queue.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueService {
    private static boolean is1_5 = true;

    public static <E> Queue<E> createQueue(int queueSize) {
        if (is1_5) {
            return new AtomQueue(queueSize);
        }
        return new SemaphoreQueue(queueSize);
    }

    public static boolean isQueue1_5() {
        return is1_5;
    }

    static {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion != null) {
            try {
                String[] vs = javaVersion.split("[.]");
                if (vs.length >= 2) {
                    int bigVersion = Integer.parseInt(vs[0]);
                    int secondVersion = Integer.parseInt(vs[1]);
                    if (bigVersion > 1) {
                        is1_5 = false;
                    } else if (secondVersion > 5) {
                        is1_5 = false;
                    }
                }
            }
            catch (Exception e) {
                is1_5 = true;
            }
        }
    }
}

