/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.pool;

import com.hundsun.t2sdk.common.share.pool.BlockingQueuePool;
import com.hundsun.t2sdk.common.share.pool.lock.TrySemaphore;
import com.hundsun.t2sdk.interfaces.share.pool.IProcessExceptionHandler;
import com.hundsun.t2sdk.interfaces.share.pool.Task;
import com.hundsun.t2sdk.interfaces.share.queue.Queue;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestlessThread
extends Thread {
    public static final int IDLE = 0;
    public static final int PROCESSING = 1;
    public static final int DEAD = 2;
    private volatile boolean canStop = false;
    private volatile boolean isActive = true;
    private final long CHECK_OWN_QUEUE_INTERVAL = 3000L;
    private BlockingQueuePool<Task> queuePool;
    private Queue<Task> myQueue;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private long processCount = 0L;
    private long procErrorCount = 0L;
    private volatile int status = 0;
    private volatile String processingName;
    private volatile Task currentTask;
    private volatile TrySemaphore stopSemaphore = null;
    long routeErrorCount = 0L;
    byte[] routeErrorCountLock = new byte[0];
    private IProcessExceptionHandler processExceptionHandler;

    public RestlessThread(Queue<Task> queue, BlockingQueuePool<Task> queuePool) {
        this.myQueue = queue;
        this.queuePool = queuePool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Queue<Task> myQueue = this.myQueue;
        while (this.isActive) {
            Task runner;
            block16: {
                runner = null;
                try {
                    int otherQueue22;
                    runner = myQueue.poll();
                    if (runner == null && (otherQueue22 = this.queuePool.currentLongestQueue()) > -1) {
                        runner = this.queuePool.getQueue(otherQueue22).poll();
                    }
                    if (runner == null) {
                        runner = myQueue.poll();
                    }
                    if (runner != null) break block16;
                    Queue<Task> otherQueue22 = myQueue;
                    synchronized (otherQueue22) {
                        myQueue.wait(3000L);
                    }
                }
                catch (InterruptedException e) {
                    runner = null;
                    this.isActive = false;
                }
            }
            if (runner != null) {
                ++this.processCount;
                this.currentTask = runner;
                this.status = 1;
                this.processingName = runner.getTaskName();
                try {
                    runner.run();
                    continue;
                }
                catch (Throwable e) {
                    ++this.procErrorCount;
                    if (this.processExceptionHandler != null) {
                        this.processExceptionHandler.processException(this, runner, e);
                        continue;
                    }
                    e.printStackTrace();
                    continue;
                }
                finally {
                    this.status = 0;
                    this.processingName = null;
                    this.currentTask = null;
                    continue;
                }
            }
            if (!this.canStop) continue;
            this.isActive = false;
        }
        TrySemaphore stopSemaphore = this.stopSemaphore;
        if (stopSemaphore != null) {
            stopSemaphore.release(1);
        }
    }

    public void notifyToStop(TrySemaphore stopSemaphore) {
        if (!super.isAlive()) {
            this.status = 2;
            stopSemaphore.release(1);
            this.isActive = false;
            this.stopSemaphore = null;
        } else {
            this.stopSemaphore = stopSemaphore;
        }
        this.canStop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (super.isAlive()) {
            try {
                this.stop();
            }
            catch (Exception exception) {
            }
            finally {
                this.isActive = false;
                this.stopSemaphore = null;
            }
        }
    }

    public Queue<Task> getQueue() {
        return this.myQueue;
    }

    public int getStatus() {
        if (super.isAlive()) {
            return this.status;
        }
        return 2;
    }

    public String getCurrentStep() {
        Task currentTask = this.currentTask;
        if (currentTask != null && this.status == 1) {
            return currentTask.getCurrentStep();
        }
        return "none";
    }

    public String getProcessingName() {
        return this.processingName;
    }

    public long getProcessCount() {
        return this.processCount;
    }

    public long getProcErrorCount() {
        return this.procErrorCount;
    }

    public String getThreadName() {
        return super.getName();
    }

    public void setThreadName(String threadName) {
        super.setName(threadName);
    }

    public long getRouteErrorCount() {
        return this.routeErrorCount;
    }

    public IProcessExceptionHandler getProcessExceptionHandler() {
        return this.processExceptionHandler;
    }

    public void setProcessExceptionHandler(IProcessExceptionHandler processExceptionHandler) {
        this.processExceptionHandler = processExceptionHandler;
    }

    public void increaseRouteErrorCount() {
        ++this.routeErrorCount;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object setProperty(String name, Object pro) {
        return this.properties.put(name, pro);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }
}

