/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.pool;

import com.hundsun.t2sdk.common.share.pool.BlockingQueuePool;
import com.hundsun.t2sdk.common.share.pool.ProcessExceptionHandler;
import com.hundsun.t2sdk.common.share.pool.RestlessThread;
import com.hundsun.t2sdk.common.share.pool.lock.TrySemaphore;
import com.hundsun.t2sdk.interfaces.share.pool.IProcessExceptionHandler;
import com.hundsun.t2sdk.interfaces.share.pool.Task;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestlessThreadExcutor {
    public static final int STATE_IDLE = 0;
    public static final int STATE_STARTING = 1;
    public static final int STATE_STARTED = 2;
    public static final int STATE_STOPING = 3;
    public static final int STATE_STOPPED = 4;
    private BlockingQueuePool<Task> queuePool;
    private ArrayList<RestlessThread> threads;
    private String poolName;
    private int queueSize;
    private volatile int state = 0;
    private IProcessExceptionHandler processExceptionHandler;

    public RestlessThreadExcutor(int threadCount, int queueSize, String poolName) {
        this(threadCount, queueSize, poolName, new ProcessExceptionHandler());
    }

    public RestlessThreadExcutor(int threadCount, int queueSize, String poolName, IProcessExceptionHandler processExceptionHandler) {
        if (processExceptionHandler == null) {
            processExceptionHandler = new ProcessExceptionHandler();
        }
        this.poolName = poolName;
        this.queueSize = queueSize;
        this.processExceptionHandler = processExceptionHandler;
        this.queuePool = new BlockingQueuePool();
        this.threads = new ArrayList(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            RestlessThread thread = new RestlessThread(this.queuePool.newQueue(queueSize), this.queuePool);
            thread.setThreadName(poolName + "#" + i);
            thread.setProcessExceptionHandler(processExceptionHandler);
            thread.setUncaughtExceptionHandler(new ThreadExceptionHandler(i));
            this.threads.add(thread);
        }
    }

    public synchronized void start() {
        this.state = 1;
        for (RestlessThread thread : this.threads) {
            thread.start();
        }
        this.state = 2;
    }

    public synchronized void stop(long timeout) {
        if (this.state == 4) {
            return;
        }
        this.state = 3;
        this.queuePool.notifyToStop();
        TrySemaphore stopSemaphore = new TrySemaphore(-1 * this.threads.size() + 1, Thread.currentThread());
        for (RestlessThread thread : this.threads) {
            thread.notifyToStop(stopSemaphore);
        }
        if (timeout > 0L) {
            try {
                if (stopSemaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
                    this.state = 4;
                    return;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            try {
                stopSemaphore.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.state = 4;
            return;
        }
        for (RestlessThread thread : this.threads) {
            if (thread.getState() == Thread.State.TERMINATED) continue;
            thread.shutdown();
        }
        this.state = 4;
    }

    public boolean execute(Task runner) {
        return this.queuePool.saveToQueue(runner);
    }

    public boolean tryExecute(Task runner) {
        return this.queuePool.trySaveToQueue(runner);
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public List<RestlessThread> getThreads() {
        return this.threads;
    }

    public BlockingQueuePool<Task> getQueuePool() {
        return this.queuePool;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public int getState() {
        return this.state;
    }

    private class ThreadExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private int threadNo;

        public ThreadExceptionHandler(int threadNo) {
            this.threadNo = threadNo;
        }

        public void uncaughtException(Thread t, Throwable e) {
            if (RestlessThreadExcutor.this.getState() == 2) {
                String threadName = t.getName() + "$new";
                RestlessThread thread = new RestlessThread(RestlessThreadExcutor.this.queuePool.getQueue(this.threadNo), RestlessThreadExcutor.this.queuePool);
                thread.setThreadName(threadName);
                thread.setProcessExceptionHandler(RestlessThreadExcutor.this.processExceptionHandler);
                thread.setUncaughtExceptionHandler(new ThreadExceptionHandler(this.threadNo));
                thread.start();
                RestlessThreadExcutor.this.threads.set(this.threadNo, thread);
            }
        }
    }
}

