/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.pool.lock;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class TrySemaphore {
    private AtomicInteger permits;
    private AtomicBoolean lock = new AtomicBoolean(false);
    private Thread waitingThread = null;

    public TrySemaphore(int permits, Thread waitingThread) {
        this.permits = new AtomicInteger(permits);
        this.waitingThread = waitingThread;
    }

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean wasInterrupted = false;
        do {
            if (this.tryAcquire()) {
                return;
            }
            if (!this.lock.compareAndSet(false, true)) continue;
            LockSupport.park();
        } while (!Thread.interrupted());
        wasInterrupted = true;
        if (wasInterrupted) {
            this.waitingThread.interrupt();
        }
    }

    public boolean tryAcquire() {
        return this.nonfairTryAcquireShared(1) >= 0;
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public boolean tryAcquire(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("invalid permits: " + permits);
        }
        return this.nonfairTryAcquireShared(permits) >= 0;
    }

    public void release() {
        this.release(1);
    }

    public void release(int permits) {
        if (this.tryReleaseShared(permits)) {
            LockSupport.unpark(this.waitingThread);
            this.lock.set(false);
        }
    }

    final int nonfairTryAcquireShared(int acquires) {
        int available;
        int remaining;
        while ((remaining = (available = this.permits.get()) - acquires) >= 0 && !this.permits.compareAndSet(available, remaining)) {
        }
        return remaining;
    }

    final boolean tryReleaseShared(int releases) {
        int p;
        while (!this.permits.compareAndSet(p = this.permits.get(), p + releases)) {
        }
        return true;
    }

    final boolean tryAcquireSharedNanos(int arg, long nanosTimeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.nonfairTryAcquireShared(arg) >= 0 || this.doAcquireSharedNanos(arg, nanosTimeout);
    }

    private boolean doAcquireSharedNanos(int arg, long nanosTimeout) throws InterruptedException {
        long lastTime = System.nanoTime();
        while (true) {
            if (this.tryAcquire()) {
                return true;
            }
            if (nanosTimeout <= 0L) {
                return false;
            }
            LockSupport.parkNanos(nanosTimeout);
            if (!Thread.interrupted()) {
                long now = System.nanoTime();
                nanosTimeout -= now - lastTime;
                lastTime = now;
                continue;
            }
            break;
        }
        throw new InterruptedException();
    }
}

