/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.queue;

import com.hundsun.t2sdk.interfaces.share.queue.Queue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemaphoreQueue<E>
implements Queue<E> {
    private final E[] items;
    private int takeIndex;
    private byte[] takeLock = new byte[0];
    private int putIndex;
    private byte[] putLock = new byte[0];
    private final int capacity;
    private final Semaphore full;
    private final Semaphore empty;
    private final Semaphore mutex;

    final int inc(int i) {
        return ++i == this.items.length ? 0 : i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(E x) {
        byte[] byArray = this.putLock;
        synchronized (this.putLock) {
            this.items[this.putIndex] = x;
            this.putIndex = this.inc(this.putIndex);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E extract() {
        E[] items = this.items;
        byte[] byArray = this.takeLock;
        synchronized (this.takeLock) {
            E x = items[this.takeIndex];
            items[this.takeIndex] = null;
            this.takeIndex = this.inc(this.takeIndex);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return x;
        }
    }

    public SemaphoreQueue(int capacity) {
        this(capacity, false);
    }

    public SemaphoreQueue(int capacity, boolean fair) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity should be equal to or greater than 0");
        }
        this.items = new Object[capacity];
        this.full = new Semaphore(0);
        this.empty = new Semaphore(capacity);
        this.mutex = new Semaphore(1);
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.empty.tryAcquire()) {
            try {
                this.insert(o);
                SemaphoreQueue semaphoreQueue = this;
                synchronized (semaphoreQueue) {
                    this.notifyAll();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.full.release();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) throws InterruptedException {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.empty.tryAcquire(timeout, unit)) {
            try {
                this.insert(o);
                SemaphoreQueue semaphoreQueue = this;
                synchronized (semaphoreQueue) {
                    this.notifyAll();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.full.release();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        if (this.full.tryAcquire()) {
            try {
                E x;
                E e = x = this.extract();
                return e;
            }
            finally {
                this.empty.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.full.tryAcquire(timeout, unit)) {
            try {
                E x;
                E e = x = this.extract();
                return e;
            }
            finally {
                this.empty.release();
            }
        }
        return null;
    }

    @Override
    public int size() {
        return this.capacity - this.empty.availablePermits();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }
}

