/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.t2sdk.common.share.util;

import java.util.Date;

public final class ByteArrayUtil {
    public static byte[] intToByteArray_C(int value) {
        byte[] bt = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return bt;
    }

    public static void intToByteArray_C(int value, byte[] bt, int offset) {
        bt[offset] = (byte)(value >> 24 & 0xFF);
        bt[offset + 1] = (byte)(value >> 16 & 0xFF);
        bt[offset + 2] = (byte)(value >> 8 & 0xFF);
        bt[offset + 3] = (byte)(value & 0xFF);
    }

    public static int byteArrayToInt_C(byte[] bts) {
        int value1 = 255;
        int value2 = 255;
        int value3 = 255;
        int value4 = 255;
        value1 = (value1 & bts[0]) * 0x1000000;
        value2 = (value2 & bts[1]) * 65536;
        value3 = (value3 & bts[2]) * 256;
        return value1 + value2 + value3 + (value4 &= bts[3]);
    }

    public static int byteArrayToInt_C(byte[] bts, int offset) {
        int value1 = 255;
        int value2 = 255;
        int value3 = 255;
        int value4 = 255;
        value1 = (value1 & bts[offset]) * 0x1000000;
        value2 = (value2 & bts[offset + 1]) * 65536;
        value3 = (value3 & bts[offset + 2]) * 256;
        return value1 + value2 + value3 + (value4 &= bts[offset + 3]);
    }

    public static byte[] intToByteArray(int v) {
        byte[] b = new byte[4];
        for (int i = 0; i < 3; ++i) {
            b[i] = (byte)(v & 0xFF);
            v >>= 8;
        }
        b[3] = (byte)(v & 0xFF);
        return b;
    }

    public static String bytesToString(byte[] b, int offset, int len) {
        return new String(b, offset, len);
    }

    public static void intToByteArray(int v, byte[] b, int offset) {
        for (int i = 0; i < 3; ++i) {
            b[offset + i] = (byte)(v & 0xFF);
            v >>= 8;
        }
        b[offset + 3] = (byte)(v & 0xFF);
    }

    public static int byteArrayToInt(byte[] v, int offset) {
        int r = 0;
        for (int i = 3; i >= 1; --i) {
            r += ByteArrayUtil.byteToInt(v[offset + i]);
            r <<= 8;
        }
        return r += ByteArrayUtil.byteToInt(v[offset + 0]);
    }

    public static long byteArrayToUnsignedInt(byte[] v, int offset) {
        long r = 0L;
        for (int i = 3; i >= 1; --i) {
            r += (long)ByteArrayUtil.byteToInt(v[offset + i]);
            r <<= 8;
        }
        return r += (long)ByteArrayUtil.byteToInt(v[offset]);
    }

    public static short byteArrayToUnsignedByte(byte[] v, int offset) {
        return (short)ByteArrayUtil.byteToInt(v[offset]);
    }

    public static int byteArrayToUnsignedShort(byte[] v, int offset) {
        int r = ByteArrayUtil.byteToInt(v[offset + 1]);
        r <<= 8;
        return r += ByteArrayUtil.byteToInt(v[offset]);
    }

    public static byte[] shortToByteArray(short v) {
        byte[] b = new byte[2];
        b[0] = (byte)(v & 0xFF);
        v = (short)(v >> 8);
        b[1] = (byte)(v & 0xFF);
        return b;
    }

    public static void shortToByteArray(short v, byte[] b, int offset) {
        b[offset + 0] = (byte)(v & 0xFF);
        v = (short)(v >> 8);
        b[offset + 1] = (byte)(v & 0xFF);
    }

    public static short byteArrayToShort(byte[] v, int offset) {
        short r = ByteArrayUtil.byteToShort(v[offset + 1]);
        r = (short)(r << 8);
        r = (short)(r + ByteArrayUtil.byteToShort(v[offset + 0]));
        if (v[offset + 1] >> 7 == -1) {
            r = (short)(r - 65536);
        }
        return r;
    }

    public static byte[] longToByteArray(long v) {
        byte[] b = new byte[8];
        for (int i = 0; i < 7; ++i) {
            b[i] = (byte)(v & 0xFFL);
            v >>= 8;
        }
        b[7] = (byte)(v & 0xFFL);
        return b;
    }

    public static void longToByteArray(long v, byte[] b, int offset) {
        for (int i = 0; i < 7; ++i) {
            b[offset + i] = (byte)(v & 0xFFL);
            v >>= 8;
        }
        b[offset + 7] = (byte)(v & 0xFFL);
    }

    public static long byteArrayToLong(byte[] v, int offset) {
        long r = 0L;
        for (int i = 7; i >= 1; --i) {
            r += (long)ByteArrayUtil.byteToInt(v[offset + i]);
            r <<= 8;
        }
        return r += (long)ByteArrayUtil.byteToInt(v[offset + 0]);
    }

    public static double byteArrayToDouble(byte[] v, int offset) {
        return Double.longBitsToDouble(ByteArrayUtil.byteArrayToLong(v, offset));
    }

    public static byte[] doubleToByteArray(double doubleValue) {
        return ByteArrayUtil.longToByteArray(Double.doubleToLongBits(doubleValue));
    }

    static void doubleToByteArray(double doubleValue, byte[] b, int offset) {
        ByteArrayUtil.longToByteArray(Double.doubleToLongBits(doubleValue), b, offset);
    }

    public static Date byteArrayToDate(byte[] v, int offset) {
        return new Date(ByteArrayUtil.byteArrayToLong(v, offset));
    }

    public static byte[] dateToByteArray(Date date) {
        return ByteArrayUtil.longToByteArray(date.getTime());
    }

    static void dateToByteArray(Date date, byte[] b, int offset) {
        ByteArrayUtil.longToByteArray(date.getTime(), b, offset);
    }

    public static float byteArrayToFloat(byte[] v, int offset) {
        return Float.intBitsToFloat(ByteArrayUtil.byteArrayToInt(v, offset));
    }

    public static byte[] floatToByteArray(float floatValue) {
        return ByteArrayUtil.intToByteArray(Float.floatToIntBits(floatValue));
    }

    static void floatToByteArray(float floatValue, byte[] b, int offset) {
        ByteArrayUtil.intToByteArray(Float.floatToIntBits(floatValue), b, offset);
    }

    public static short byteToShort(byte b) {
        short r = b;
        if (b < 0) {
            r = (short)(r + 256);
        }
        return r;
    }

    public static int byteToInt(byte b) {
        int r = b;
        if (b < 0) {
            r += 256;
        }
        return r;
    }
}

